/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.mp3;

import com.limegroup.gnutella.ByteOrder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public final class MP3Info {
    private final String _file;
    private int _header;
    private VBRHeader _vbrHeader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MP3Info(String string) throws IOException {
        this._file = string;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        FileInputStream fileInputStream = null;
        byte[] byArray = new byte[2048];
        try {
            fileInputStream = new FileInputStream(this._file);
            n4 = fileInputStream.read(byArray, 0, byArray.length);
            if (n4 < 4) {
                throw new IOException("early EOF, tiny file?");
            }
            if (!(byArray[0] != 105 && byArray[0] != 73 || byArray[1] != 100 && byArray[1] != 68 || byArray[2] != 51)) {
                n = byArray[6] << 7 | byArray[7] << 7 | byArray[8] << 7 | byArray[9];
                if (n > 0) {
                    n += 10;
                } else if (n < 0) {
                    n = 0;
                }
            }
            block9: do {
                if (n2 < byArray.length - 3) {
                    n3 = n4 - 3;
                } else {
                    n = 0;
                    n3 = n4;
                }
                while (n < n3) {
                    if (byArray[n] == -1 && (byArray[n + 1] & 0xFF) >= 224) {
                        this._header = ByteOrder.ubyte2int(byArray[n + 3]) | ByteOrder.ubyte2int(byArray[n + 2]) << 8 | ByteOrder.ubyte2int(byArray[n + 1]) << 16 | ByteOrder.ubyte2int(byArray[n]) << 24;
                        if (this.getVersionIndex() != 1 && this.getLayerIndex() != 0 && this.getBitrateIndex() != 0 && this.getBitrateIndex() != 15 && this.getFrequencyIndex() != 3 && this.getEmphasisIndex() != 2) {
                            n2 += n;
                            break block9;
                        }
                    }
                    ++n;
                }
                if (n3 != -1) {
                    byArray[0] = byArray[n4 - 3];
                    byArray[1] = byArray[n4 - 2];
                    byArray[2] = byArray[n4 - 1];
                }
                n2 += n4 - 3;
                n4 = fileInputStream.read(byArray, 3, byArray.length - 3);
                if (n4 >= 6) continue;
                throw new IOException("MP3 Header not found.");
            } while (n4 != -1 && n2 < 100000);
            if (n4 == -1 || n2 >= 100000) {
                this._header = 0;
                throw new IOException("MP3 header not found.");
            }
            int n5 = byArray.length - n - 3 - 120 - 36;
            if (n5 < 0) {
                n -= n5;
                int n6 = 0;
                for (n5 = -n5; n5 < byArray.length; ++n5) {
                    byArray[n6] = byArray[n5];
                    ++n6;
                }
                n4 = fileInputStream.read(byArray, n6, byArray.length - n6);
            }
            n = this.getVersionIndex() == 3 ? (n += this.getModeIndex() == 3 ? 21 : 36) : (n += this.getModeIndex() == 3 ? 23 : 21);
            switch (byArray[n + 0]) {
                case 88: {
                    if (byArray[n + 1] != 105 && byArray[n + 1] != 73 || byArray[n + 2] != 110 && byArray[n + 2] != 78 || byArray[n + 3] != 103 && byArray[n + 3] != 71) break;
                    this.loadXingHeader(byArray, n + 4);
                    break;
                }
                case 86: {
                    if (byArray[n + 1] != 66 || byArray[n + 2] != 82 || byArray[n + 3] != 73) break;
                    this.loadFhgHeader(byArray, n + 4);
                }
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    public int getBitRate() {
        double d;
        int n;
        if (this.hasVariableBitRate() && (n = this._vbrHeader.getBitRate()) != -1) {
            return n;
        }
        long l = this.getFileSize();
        int n2 = (int)((double)l / ((double)l / (d = (double)((this.getLayerIndex() == 3 ? 12000 : 144000) * this.getHeaderBitRate()) / (double)this.getFrequency())) * (double)this.getFrequency() / (double)(this.getLayerIndex() == 3 ? 12000 : 144000));
        if (n2 < 1) {
            return this.getHeaderBitRate();
        }
        return n2;
    }

    private int getBitrateIndex() {
        return this._header >> 12 & 0xF;
    }

    public String getEmphasis() {
        switch (this.getEmphasisIndex()) {
            case 0: {
                return "none";
            }
            case 1: {
                return "50/15 ms";
            }
            case 2: {
                return null;
            }
            case 3: {
                return "CCIT J.17";
            }
        }
        return "<unknown>";
    }

    private int getEmphasisIndex() {
        return this._header & 3;
    }

    public long getFileSize() {
        if (this.hasVariableBitRate() && this._vbrHeader.numBytes != -1) {
            return this._vbrHeader.numBytes;
        }
        return new File(this._file).length();
    }

    private int getFrameSync() {
        return this._header >> 21 & 0x7FF;
    }

    public int getFrequency() {
        switch (this.getVersionIndex()) {
            case 0: {
                switch (this.getFrequencyIndex()) {
                    case 0: {
                        return 11025;
                    }
                    case 1: {
                        return 12000;
                    }
                    case 2: {
                        return 8000;
                    }
                }
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                switch (this.getFrequencyIndex()) {
                    case 0: {
                        return 22050;
                    }
                    case 1: {
                        return 24000;
                    }
                    case 2: {
                        return 16000;
                    }
                }
                return -1;
            }
            case 3: {
                switch (this.getFrequencyIndex()) {
                    case 0: {
                        return 44100;
                    }
                    case 1: {
                        return 48000;
                    }
                    case 2: {
                        return 32000;
                    }
                }
                return -1;
            }
        }
        return -1;
    }

    private int getFrequencyIndex() {
        return this._header >> 10 & 3;
    }

    public int getHeaderBitRate() {
        int n = -1;
        switch (this.getVersionIndex()) {
            case 0: 
            case 2: {
                if (this.getLayer_Numeric() == 1) {
                    n = 3;
                    break;
                }
                n = 4;
                break;
            }
            default: {
                return 0;
            }
            case 3: {
                n = this.getLayer_Numeric() - 1;
            }
        }
        try {
            short[] sArray = new short[]{0, 0, 0, 0, 0, 32, 32, 32, 32, 8, 64, 48, 40, 48, 16, 96, 56, 48, 56, 24, 128, 64, 56, 64, 32, 160, 80, 64, 80, 40, 192, 96, 80, 96, 48, 224, 112, 96, 112, 56, 256, 128, 112, 128, 64, 288, 160, 128, 144, 80, 320, 192, 160, 160, 96, 352, 224, 192, 176, 112, 384, 256, 224, 192, 128, 416, 320, 256, 224, 144, 448, 384, 320, 256, 160};
            return sArray[this.getBitrateIndex() * 5 + n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return -1;
        }
    }

    public int getLayer_Numeric() {
        return 4 - this.getLayerIndex();
    }

    public String getLayer_String() {
        switch (this.getLayerIndex()) {
            case 1: {
                return "Layer III";
            }
            case 2: {
                return "Layer II";
            }
            case 3: {
                return "Layer I";
            }
        }
        return "Layer ?";
    }

    private int getLayerIndex() {
        return this._header >> 17 & 3;
    }

    public long getLengthInSeconds() {
        int n;
        if (this.hasVariableBitRate() && (n = this._vbrHeader.getLengthInSeconds()) != -1) {
            return n;
        }
        return this.getFileSize() / (long)(this.getHeaderBitRate() * 1000 / 8);
    }

    public String getMode() {
        switch (this.getModeIndex()) {
            case 0: {
                return "Stereo";
            }
            case 1: {
                return "Joint Stereo";
            }
            case 2: {
                return "Dual Channel";
            }
            case 3: {
                return "Single Channel";
            }
        }
        return "<unknown>";
    }

    private int getModeExtIndex() {
        return this._header >> 4 & 3;
    }

    private int getModeIndex() {
        return this._header >> 6 & 3;
    }

    public int getNumberOfFrames() {
        if (this.hasVariableBitRate() && this._vbrHeader.numFrames != -1) {
            return this._vbrHeader.numFrames;
        }
        return (int)(this.getFileSize() / (long)(this.getLayerIndex() == 3 ? 12000 : 144000 * this.getBitRate() / this.getFrequency() + (this.isPadded() ? (this.getLayerIndex() == 3 ? 32 : 8) : 0)));
    }

    public VBRHeader getVBRHeader() {
        return this._vbrHeader;
    }

    public double getVersion_Numeric() {
        switch (this.getVersionIndex()) {
            case 0: {
                return 2.5;
            }
            default: {
                return 0.0;
            }
            case 2: {
                return 2.0;
            }
            case 3: 
        }
        return 1.0;
    }

    public String getVersion_String() {
        switch (this.getVersionIndex()) {
            case 0: {
                return "MPEG Version 2.5";
            }
            case 1: {
                return null;
            }
            case 2: {
                return "MPEG Version 2.0";
            }
            case 3: {
                return "MPEG Version 1.0";
            }
        }
        return "MPEG Version ?";
    }

    private int getVersionIndex() {
        return this._header >> 19 & 3;
    }

    public boolean hasVariableBitRate() {
        return this._vbrHeader != null;
    }

    public boolean isCoprighted() {
        return (this._header >> 3 & 1) != 0;
    }

    public boolean isOriginal() {
        return (this._header >> 2 & 1) != 0;
    }

    public boolean isPadded() {
        return (this._header >> 9 & 1) != 0;
    }

    public boolean isPrivate() {
        return (this._header >> 8 & 1) != 0;
    }

    public boolean isProtected() {
        return (this._header >> 16 & 1) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRiffWav() {
        boolean bl = false;
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(this._file);
        byte[] byArray = new byte[16];
        fileInputStream.read(byArray);
        bl = byArray[0] == 82 && byArray[1] == 73 && byArray[2] == 70 && byArray[3] == 70 && byArray[8] == 87 && byArray[9] == 65 && byArray[10] == 86 && byArray[11] == 69 && byArray[12] == 102 && byArray[13] == 109 && byArray[14] == 116 && byArray[15] == 32;
        Object var5_5 = null;
        if (fileInputStream == null) return bl;
        try {
            fileInputStream.close();
            return bl;
        }
        catch (IOException iOException) {}
        return bl;
        {
            catch (IOException iOException) {
                Object var5_6 = null;
                if (fileInputStream == null) return bl;
                try {
                    fileInputStream.close();
                    return bl;
                }
                catch (IOException iOException2) {}
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void loadFhgHeader(byte[] byArray, int n) {
        this._vbrHeader = new VBRHeader();
        this._vbrHeader.scale = ByteOrder.ubyte2int(byArray[n += 2]);
        this._vbrHeader.numBytes = (ByteOrder.ubyte2int(byArray[++n]) << 24) + (ByteOrder.ubyte2int(byArray[++n]) << 16) + (ByteOrder.ubyte2int(byArray[++n]) << 8) + ByteOrder.ubyte2int(byArray[++n]);
        this._vbrHeader.numFrames = (ByteOrder.ubyte2int(byArray[++n]) << 24) + (ByteOrder.ubyte2int(byArray[++n]) << 16) + (ByteOrder.ubyte2int(byArray[++n]) << 8) + ByteOrder.ubyte2int(byArray[++n]);
    }

    private void loadXingHeader(byte[] byArray, int n) {
        this._vbrHeader = new VBRHeader();
        byte by = (byte)ByteOrder.ubyte2int(byArray[n += 3]);
        if ((by & 1) != 0) {
            this._vbrHeader.numFrames = (ByteOrder.ubyte2int(byArray[++n]) << 24) + (ByteOrder.ubyte2int(byArray[++n]) << 16) + (ByteOrder.ubyte2int(byArray[++n]) << 8) + ByteOrder.ubyte2int(byArray[++n]);
        }
        if ((by & 2) != 0) {
            this._vbrHeader.numBytes = (ByteOrder.ubyte2int(byArray[++n]) << 24) + (ByteOrder.ubyte2int(byArray[++n]) << 16) + (ByteOrder.ubyte2int(byArray[++n]) << 8) + ByteOrder.ubyte2int(byArray[++n]);
        }
        if ((by & 4) != 0) {
            VBRHeader.access$402(this._vbrHeader, new byte[100]);
            System.arraycopy(byArray, ++n, this._vbrHeader.toc, 0, 100);
            n += 99;
        }
        if ((by & 8) != 0) {
            this._vbrHeader.scale = ByteOrder.ubyte2int(byArray[n += 4]);
        }
    }

    final class VBRHeader {
        private int numFrames = -1;
        private int numBytes = -1;
        private int scale = -1;
        private byte[] toc;

        VBRHeader() {
        }

        int getScale() {
            return this.scale;
        }

        byte[] getTableOfContents() {
            return this.toc;
        }

        int getBitRate() {
            if (this.numFrames != -1 && this.numBytes != -1) {
                double d = 0.0;
                switch (MP3Info.this.getLayerIndex()) {
                    case 1: 
                    case 2: {
                        d = 1152.0;
                        break;
                    }
                    case 3: {
                        d = 384.0;
                    }
                }
                d /= (double)MP3Info.this.getFrequency();
                if (MP3Info.this.getVersion_Numeric() == 2.0 || MP3Info.this.getVersion_Numeric() == 0.0) {
                    d /= 2.0;
                }
                return (int)((double)(this.numBytes * 8) / (d * (double)this.numFrames * 1000.0));
            }
            return -1;
        }

        int getLengthInSeconds() {
            if (this.numFrames != -1) {
                double d = 0.0;
                switch (MP3Info.this.getLayerIndex()) {
                    case 1: 
                    case 2: {
                        d = 1152.0;
                        break;
                    }
                    case 3: {
                        d = 384.0;
                    }
                }
                d /= (double)MP3Info.this.getFrequency();
                if (MP3Info.this.getVersion_Numeric() == 2.0 || MP3Info.this.getVersion_Numeric() == 0.0) {
                    d /= 2.0;
                }
                return (int)(d * (double)this.numFrames);
            }
            return -1;
        }

        static /* synthetic */ byte[] access$402(VBRHeader vBRHeader, byte[] byArray) {
            vBRHeader.toc = byArray;
            return byArray;
        }
    }
}

