/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.routing;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.routing.RouteTableMessage;
import com.limegroup.gnutella.statistics.DroppedSentMessageStatHandler;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import java.io.IOException;
import java.io.OutputStream;

public class PatchTableMessage
extends RouteTableMessage {
    private short sequenceNumber;
    private short sequenceSize;
    private byte compressor;
    private byte entryBits;
    private byte[] data;
    public static final byte COMPRESSOR_NONE = 0;
    public static final byte COMPRESSOR_DEFLATE = 1;

    public PatchTableMessage(short s, short s2, byte by, byte by2, byte[] byArray, int n, int n2) {
        super((byte)1, 5 + (n2 - n), (byte)1);
        this.sequenceNumber = s;
        this.sequenceSize = s2;
        this.compressor = by;
        this.entryBits = by2;
        this.data = new byte[n2 - n];
        System.arraycopy(byArray, n, this.data, 0, this.data.length);
    }

    protected void writePayloadData(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[4 + this.data.length];
        byArray[0] = (byte)this.sequenceNumber;
        byArray[1] = (byte)this.sequenceSize;
        byArray[2] = this.compressor;
        byArray[3] = this.entryBits;
        System.arraycopy(this.data, 0, byArray, 4, this.data.length);
        outputStream.write(byArray);
        if (Message.RECORD_STATS) {
            SentMessageStatHandler.TCP_PATCH_ROUTE_TABLE_MESSAGES.addMessage(this);
        }
    }

    protected PatchTableMessage(byte[] byArray, byte by, byte by2, byte[] byArray2) throws BadPacketException {
        super(byArray, by, by2, byArray2.length, (byte)1);
        Assert.that(byArray2[0] == 1);
        this.sequenceNumber = (short)ByteOrder.ubyte2int(byArray2[1]);
        this.sequenceSize = (short)ByteOrder.ubyte2int(byArray2[2]);
        if (this.sequenceNumber < 1 || this.sequenceSize < 1 || this.sequenceNumber > this.sequenceSize) {
            throw new BadPacketException("Bad sequence/size: " + this.sequenceNumber + "/" + this.sequenceSize);
        }
        this.compressor = byArray2[3];
        if (this.compressor != 0 && this.compressor != 1) {
            throw new BadPacketException("Bad compressor: " + this.compressor);
        }
        this.entryBits = byArray2[4];
        if (this.entryBits < 0) {
            throw new BadPacketException("Negative entryBits: " + this.entryBits);
        }
        this.data = new byte[byArray2.length - 5];
        System.arraycopy(byArray2, 5, this.data, 0, this.data.length);
    }

    public short getSequenceNumber() {
        return this.sequenceNumber;
    }

    public short getSequenceSize() {
        return this.sequenceSize;
    }

    public byte getCompressor() {
        return this.compressor;
    }

    public byte getEntryBits() {
        return this.entryBits;
    }

    public byte[] getData() {
        return this.data;
    }

    public void recordDrop() {
        if (Message.RECORD_STATS) {
            DroppedSentMessageStatHandler.TCP_PATCH_ROUTE_TABLE_MESSAGES.addMessage(this);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{PATCH, Sequence: " + this.getSequenceNumber() + "/" + this.getSequenceSize() + ", Bits: " + this.entryBits + ", Compr: " + this.getCompressor() + ", [");
        stringBuffer.append("<" + this.data.length + " bytes>");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

