/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SearchResultHandler {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$search$SearchResultHandler == null ? (class$com$limegroup$gnutella$search$SearchResultHandler = SearchResultHandler.class$("com.limegroup.gnutella.search.SearchResultHandler")) : class$com$limegroup$gnutella$search$SearchResultHandler));
    private static final int QUERY_EXPIRE_TIME = 30000;
    public static final int REPORT_INTERVAL = 15;
    public static final int MAX_RESULTS = 65535;
    private final List GUID_COUNTS = new Vector();
    static /* synthetic */ Class class$com$limegroup$gnutella$search$SearchResultHandler;

    public void handleQueryReply(QueryReply queryReply) {
        this.handleReply(queryReply);
    }

    public void addQuery(QueryRequest queryRequest) {
        LOG.trace((Object)"entered SearchResultHandler.addQuery(QueryRequest)");
        GuidCount guidCount = new GuidCount(queryRequest);
        this.GUID_COUNTS.add((Object)guidCount);
    }

    public void removeQuery(GUID gUID) {
        LOG.trace((Object)"entered SearchResultHandler.removeQuery(GUID)");
        GuidCount guidCount = this.removeQueryInternal(gUID);
        if (guidCount != null && !guidCount.isFinished()) {
            QueryStatusResponse queryStatusResponse = new QueryStatusResponse(gUID, 65535);
            RouterService.getConnectionManager().updateQueryStatus(queryStatusResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getQueriesToReSend() {
        LOG.trace((Object)"entered SearchResultHandler.getQueriesToSend()");
        LinkedList linkedList = null;
        List list = this.GUID_COUNTS;
        synchronized (list) {
            long l = System.currentTimeMillis();
            Iterator iterator = this.GUID_COUNTS.iterator();
            while (iterator.hasNext()) {
                GuidCount guidCount = (GuidCount)iterator.next();
                if (!this.isQueryStillValid(guidCount, l)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("adding " + guidCount + " to list of queries to resend"));
                }
                if (linkedList == null) {
                    linkedList = new LinkedList();
                }
                linkedList.add((Object)guidCount.getQueryRequest());
            }
        }
        if (linkedList == null) {
            return DataUtils.EMPTY_LIST;
        }
        return linkedList;
    }

    public int getNumResultsForQuery(GUID gUID) {
        GuidCount guidCount = this.retrieveGuidCount(gUID);
        if (guidCount != null) {
            return guidCount.getNumResults();
        }
        return -1;
    }

    private boolean handleReply(QueryReply queryReply) {
        HostData hostData;
        try {
            hostData = queryReply.getHostData();
        }
        catch (BadPacketException badPacketException) {
            LOG.debug((Object)"bad packet reading qr", (Throwable)badPacketException);
            return false;
        }
        if (!hostData.isReplyToMulticastQuery() && !queryReply.isBrowseHostReply()) {
            if (hostData.getQuality() < SearchSettings.MINIMUM_SEARCH_QUALITY.getValue()) {
                LOG.debug((Object)"Ignoring because low quality");
                return false;
            }
            if (hostData.getSpeed() < SearchSettings.MINIMUM_SEARCH_SPEED.getValue()) {
                LOG.debug((Object)"Ignoring because low speed");
                return false;
            }
            if (hostData.isFirewalled() && !NetworkUtils.isVeryCloseIP(queryReply.getIPBytes()) && (!RouterService.acceptedIncomingConnection() || NetworkUtils.isPrivateAddress(RouterService.getAddress()))) {
                LOG.debug((Object)"Ignoring from firewall funkiness");
                return false;
            }
        }
        List list = null;
        try {
            list = queryReply.getResultsAsList();
        }
        catch (BadPacketException badPacketException) {
            LOG.debug((Object)"Error gettig results", (Throwable)badPacketException);
            return false;
        }
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Response response = (Response)iterator.next();
            if (!RouterService.matchesType(hostData.getMessageGUID(), response) || RouterService.isMandragoreWorm(hostData.getMessageGUID(), response)) continue;
            RemoteFileDesc remoteFileDesc = response.toRemoteFileDesc(hostData);
            String string = remoteFileDesc.getFileName().toLowerCase();
            int n2 = remoteFileDesc.getSize();
            if (n2 == 11354 || n2 == 48139 || n2 == 50327 || n2 == 53379 || n2 == 56993 || n2 == 76233 || n2 == 76235 || n2 == 76249 || n2 == 76251 || n2 == 77282 || n2 == 77284 || n2 == 95927 || n2 == 96191 || n2 == 96268 || n2 == 121836 || n2 == 200706 || n2 == 283692 || n2 == 822182 || n2 == 863798 || n2 == 938820 || n2 == 1058868 || n2 == 1105392 || n2 == 1155729 || n2 == 1167481 || n2 == 1216226 || n2 == 1251562 || n2 == 1252087 || n2 == 0x132212 || n2 == 1279141 || n2 == 1279142 || n2 == 1411929 || n2 == 1431124 || n2 == 3515161 || n2 == 3545425 || n2 == 3877629 || n2 == 5745425 || n2 == 5745425 || n2 == 12101663 || string.indexOf("cracked") != -1 && (string.endsWith(".html") || string.endsWith(".wma") || string.endsWith(".xml") || string.indexOf("special edition") != -1) || string.startsWith("horny ") && (string.endsWith(".html") || string.endsWith(".zip")) || string.startsWith("sexy ") && string.endsWith(".zip") || string.endsWith(" (2).zip") || string.endsWith(" (album.edition).wma") || string.endsWith(" (cover).wma") || string.endsWith(" (divx).zip") || string.endsWith(" (front).wma") || string.endsWith(" (intro).wma") || string.endsWith(" (latest).wma") || string.endsWith(" (mix).wma") || string.endsWith(" (music).zip") || string.endsWith(" (new.album).wma") || string.endsWith(" (new.single).wma") || string.endsWith(" (original).zip") || string.endsWith(" (porn).zip") || string.endsWith(" (radio.edit).wma") || string.endsWith(" (radio.version).zip") || string.endsWith(" (remix).wma") || string.endsWith(" (rock).wma") || string.endsWith(" (single).zip") || string.endsWith(" (special).wma") || string.endsWith(" (special.edition).wma") || string.endsWith(" (svcd).zip") || string.endsWith(" (tool).wma") || string.endsWith(" (uncensored).html") || string.endsWith(" (uncensored).mov") || string.endsWith(" (uncensored).zip") || string.endsWith(" (unreleased).zip") || string.endsWith(" (very hot).mpg") || string.endsWith(" (vocal).wma") || string.endsWith(" (working) album.wma") || string.endsWith(" (working) divx.zip") || string.endsWith(" *better version* [key].zip") || string.endsWith(" *uncensored* single.wma") || string.endsWith(" *working* (full).zip") || string.endsWith(" *working* dirty.zip") || string.endsWith(" - best music.zip") || string.endsWith(" - gives blowjob.html") || string.endsWith(" - great blowjob.html") || string.endsWith(" - greatest hits.mp3") || string.endsWith(" - greatest hits.wma") || string.endsWith(" - pics.html") || string.endsWith(" 2006.zip") || string.endsWith(" 2007.zip") || string.endsWith(" [!].zip") || string.endsWith(" [album.edition].wma") || string.endsWith(" [banned.version].zip") || string.endsWith(" [bonus].wma") || string.endsWith(" [cd].zip") || string.endsWith(" [dirty].zip") || string.endsWith(" [divx].zip") || string.endsWith(" [explicit].zip") || string.endsWith(" [extended.edition].wma") || string.endsWith(" [full].zip") || string.endsWith(" [mix].zip") || string.endsWith(" [new.single].wma") || string.endsWith(" [porn].zip") || string.endsWith(" [radio.version].zip") || string.endsWith(" [registered].wma") || string.endsWith(" [rock].wma") || string.endsWith(" [single].wma") || string.endsWith(" [soundtrack].zip") || string.endsWith(" [svcd].zip") || string.endsWith(" [techno.remix].zip") || string.endsWith(" [techno].zip") || string.endsWith(" [theme].wma") || string.endsWith(" [tool].wma") || string.endsWith(" [ultimate.edition].wma") || string.endsWith(" [vcd].zip") || string.endsWith(" [video].wma") || string.endsWith(" [wyzo].zip") || string.endsWith(" [x].zip") || string.endsWith(" album.edition.zip") || string.endsWith(" back.wma") || string.endsWith(" bdsm.html") || string.endsWith(" bearshare download accelerator.zip") || string.endsWith(" bittorrent downloader.exe") || string.endsWith(" bittorrent downloader.zip") || string.endsWith(" bonus.zip") || string.endsWith(" by cdz intro.wma") || string.endsWith(" by cdz theme.zip") || string.endsWith(" by incite (1).zip") || string.endsWith(" by pr0nstars key.wma") || string.endsWith(" clip.zip") || string.endsWith(" cover.zip") || string.endsWith(" crack by frost.zip") || string.endsWith(" cute girl has orgasm on webcam.mp3") || string.endsWith(" cute girl has orgasm on webcam.mpg") || string.endsWith(" dd breasts.zip") || string.endsWith(" download free adult videos.zip") || string.endsWith(" dream of jenna cd1 jenna.wma") || string.endsWith(" dvdrip.zip") || string.endsWith(" extended.edition.zip") || string.endsWith(" extended.wma") || string.endsWith(" free access 150 adult porn sites.zip") || string.endsWith(" free access to 150 adult porn sites.zip") || string.endsWith(" fucking.html") || string.endsWith(" full.zip") || string.endsWith(" get hacked passwords adult porn sites for free.zip") || string.endsWith(" get hacked passwords to adult porn sites for free.zip") || string.endsWith(" hentai anime.zip") || string.endsWith(" keygen [ssg].zip") || string.endsWith(" limewire download accelerator.zip") || string.endsWith(" mp3.html") || string.endsWith(" music.html") || string.endsWith(" naked.html") || string.endsWith(" naked.zip") || string.endsWith(" new.zip") || string.endsWith(" nocd patch.zip") || string.endsWith(" nodvd patch.zip") || string.endsWith(" online installer.zip") || string.endsWith(" pictures.html") || string.endsWith(" radio.edition.zip") || string.endsWith(" remix.zip") || string.endsWith(" ringtones.html") || string.endsWith(" securely with new secured browser.zip") || string.endsWith(" sexy girl has shaking orgasm during sex.mpg") || string.endsWith(" share accelerator.zip") || string.endsWith(" song.zip") || string.endsWith(" soul.zip") || string.endsWith(" special.edition.wma") || string.endsWith(" special.zip") || string.endsWith(" techno.zip") || string.endsWith(" ultimate.edition.zip") || string.endsWith(" using emule multimedia toolbar.zip") || string.endsWith(" using multimedia toolbar.zip") || string.endsWith(" using the best ultimate player.zip") || string.endsWith(" video (extended).wma") || string.endsWith(" video.zip") || string.endsWith(" videos.html") || string.endsWith(" vocal.wma") || string.endsWith(" web hottest videos personal player.exe") || string.endsWith(" webcam.html") || string.endsWith(" wet and wild.zip") || string.endsWith(" with bonus.zip") || string.endsWith(" with new secured emule.zip") || string.endsWith(" with the fastest bittorrent downloader.zip") || string.endsWith(" with the ultimate player.zip") || string.endsWith(" xvid.zip") || string.endsWith(" young and cute.zip") || string.endsWith("-vids.html") || string.endsWith("-xcd.wma") || string.endsWith("-xxx.wmv") || string.endsWith("-xxx.wmv") || string.equals("official limewire pro available here.com") || string.indexOf("www.efreeclub.com") != -1 || string.startsWith("!!!!!!!! ") || string.startsWith("###### ") || string.startsWith("(cinemaniacs) ") || string.startsWith("(corp) ") || string.startsWith("(deviance) ") || string.startsWith("(fusion) ") || string.startsWith("(genius) ") || string.startsWith("(h2o) ") || string.startsWith("*better version* ") || string.startsWith("*myth* ") || string.startsWith("*naked* ") || string.startsWith("*strike* ") || string.startsWith("*subnet* ") || string.startsWith("- presented by ash - ") || string.startsWith("---===== ") || string.startsWith("curly haired cutie with size ") || string.startsWith("download music ") || string.startsWith("free 1000 gas gift card www.efreeclub.com ") || string.startsWith("free apple computer system www.efreeclub.com ") || string.startsWith("get music ") || string.startsWith("mp3 escape great the girls like ") || string.startsWith("warning, visit ") || remoteFileDesc.getXMLDoc() != null && remoteFileDesc.getXMLDoc().getValue("audios__audio__title__") != null && remoteFileDesc.getXMLDoc().getValue("audios__audio__title__").startsWith("not related : ")) continue;
            Set set = response.getLocations();
            RouterService.getCallback().handleQueryResult(remoteFileDesc, hostData, set);
            ++n;
        }
        this.accountAndUpdateDynamicQueriers(queryReply, n);
        return n > 0;
    }

    private void accountAndUpdateDynamicQueriers(QueryReply queryReply, int n) {
        LOG.trace((Object)"SRH.accountAndUpdateDynamicQueriers(): entered.");
        if (n > 0) {
            GuidCount guidCount = this.retrieveGuidCount(new GUID(queryReply.getGUID()));
            if (guidCount == null) {
                return;
            }
            LOG.trace((Object)"SRH.accountAndUpdateDynamicQueriers(): incrementing.");
            guidCount.increment(n);
            if (RouterService.isShieldedLeaf() && !guidCount.isFinished() && guidCount.getNumResults() > guidCount.getNextReportNum()) {
                LOG.trace((Object)"SRH.accountAndUpdateDynamicQueriers(): telling UPs.");
                guidCount.tallyReport();
                if (guidCount.getNumResults() > 250) {
                    guidCount.markAsFinished();
                }
                int n2 = guidCount.isFinished() ? 65535 : guidCount.getNumResults() / 4;
                QueryStatusResponse queryStatusResponse = new QueryStatusResponse(guidCount.getGUID(), n2);
                RouterService.getConnectionManager().updateQueryStatus(queryStatusResponse);
            }
        }
        LOG.trace((Object)"SRH.accountAndUpdateDynamicQueriers(): returning.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GuidCount removeQueryInternal(GUID gUID) {
        List list = this.GUID_COUNTS;
        synchronized (list) {
            Iterator iterator = this.GUID_COUNTS.iterator();
            while (iterator.hasNext()) {
                GuidCount guidCount = (GuidCount)iterator.next();
                if (!guidCount.getGUID().equals(gUID)) continue;
                iterator.remove();
                return guidCount;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GuidCount retrieveGuidCount(GUID gUID) {
        List list = this.GUID_COUNTS;
        synchronized (list) {
            Iterator iterator = this.GUID_COUNTS.iterator();
            while (iterator.hasNext()) {
                GuidCount guidCount = (GuidCount)iterator.next();
                if (!guidCount.getGUID().equals(gUID)) continue;
                return guidCount;
            }
        }
        return null;
    }

    private boolean isQueryStillValid(GuidCount guidCount, long l) {
        LOG.trace((Object)"entered SearchResultHandler.isQueryStillValid(GuidCount)");
        return l < guidCount.getTime() + 30000L && guidCount.getNumResults() < 250;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class GuidCount {
        private final long _time;
        private final GUID _guid;
        private final QueryRequest _qr;
        private int _numResults;
        private int _nextReportNum = 15;
        private boolean markAsFinished = false;

        public GuidCount(QueryRequest queryRequest) {
            this._qr = queryRequest;
            this._guid = new GUID(queryRequest.getGUID());
            this._numResults = 0;
            this._time = System.currentTimeMillis();
        }

        public GUID getGUID() {
            return this._guid;
        }

        public int getNumResults() {
            return this._numResults;
        }

        public int getNextReportNum() {
            return this._nextReportNum;
        }

        public long getTime() {
            return this._time;
        }

        public QueryRequest getQueryRequest() {
            return this._qr;
        }

        public boolean isFinished() {
            return this.markAsFinished;
        }

        public void tallyReport() {
            this._nextReportNum = this._numResults + 15;
        }

        public void increment(int n) {
            this._numResults += n;
        }

        public void markAsFinished() {
            this.markAsFinished = true;
        }

        public String toString() {
            return "" + this._guid + ":" + this._numResults + ":" + this._nextReportNum;
        }
    }
}

