/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree;

import com.bitzi.util.Base32;
import com.bitzi.util.Tiger;
import com.bitzi.util.TigerTree;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.tigertree.HashTreeHandler;
import com.limegroup.gnutella.tigertree.HashTreeNodeManager;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class HashTree
implements HTTPHeaderValue,
Serializable {
    private static final long serialVersionUID = -5752974896215224469L;
    private static final transient Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$tigertree$HashTree == null ? (class$com$limegroup$gnutella$tigertree$HashTree = HashTree.class$("com.limegroup.gnutella.tigertree.HashTree")) : class$com$limegroup$gnutella$tigertree$HashTree));
    private static final transient int KB = 1024;
    private static final transient int MB = 0x100000;
    static final transient int BLOCK_SIZE = 1024;
    private static final transient byte INTERNAL_HASH_PREFIX = 1;
    private final List NODES;
    private final byte[] ROOT_HASH;
    private final long FILE_SIZE;
    private final int DEPTH;
    private final String THEX_URI;
    private transient HashTreeHandler _treeWriter;
    static /* synthetic */ Class class$com$limegroup$gnutella$tigertree$HashTree;

    private HashTree(List list, String string, long l) {
        this.THEX_URI = "/uri-res/N2X?" + string;
        this.NODES = (List)list.get(list.size() - 1);
        this.FILE_SIZE = l;
        this.ROOT_HASH = (byte[])((List)list.get(0)).get(0);
        this.DEPTH = list.size() - 1;
        Assert.that(HashTree.log2Ceil(this.NODES.size()) == this.DEPTH);
        HashTreeNodeManager.instance().register(this, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HashTree createHashTree(FileDesc fileDesc) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("creating hashtree for file " + fileDesc));
        }
        InputStream inputStream = null;
        try {
            inputStream = fileDesc.createInputStream();
            HashTree hashTree = HashTree.createHashTree(fileDesc.getSize(), inputStream, fileDesc.getSHA1Urn());
            return hashTree;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static HashTree createHashTree(long l, InputStream inputStream, URN uRN) throws IOException {
        int n = HashTree.calculateDepth(l);
        int n2 = 1 << n;
        int n3 = (int)(l + 1L) / n2;
        int n4 = HashTree.log2Ceil(n3);
        int n5 = 1 << n4;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("fileSize " + l));
            LOG.debug((Object)("depth " + n));
            LOG.debug((Object)("nodeSize " + n5));
        }
        Assert.that((long)n5 >= l / (long)n2, "nodeSize: " + n5 + ", fileSize: " + l + ", maxNode: " + n2);
        Assert.that((long)n5 <= l / (long)n2 * 2L, "nodeSize: " + n5 + ", fileSize: " + l + ", maxNode: " + n2);
        List list = HashTree.createTTNodes(n5, l, inputStream);
        List list2 = HashTree.createAllParentNodes(list);
        return new HashTree(list2, uRN.toString(), l);
    }

    public static HashTree createHashTree(InputStream inputStream, String string, String string2, long l) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("reading " + string + "." + string2 + " dime data."));
        }
        return new HashTree(HashTreeHandler.read(inputStream, l, string2), string, l);
    }

    public List getCorruptRanges(InputStream inputStream) throws IOException {
        LOG.trace((Object)"getting corrupt ranges ");
        ArrayList arrayList = new ArrayList();
        int n = HashTree.log2Ceil((int)this.FILE_SIZE) - this.DEPTH;
        int n2 = 1 << n;
        List list = HashTree.createTTNodes(n2, this.FILE_SIZE, inputStream);
        int n3 = Math.min(list.size(), this.NODES.size());
        block0: for (int i = 0; i < n3; ++i) {
            byte[] byArray = (byte[])list.get(i);
            byte[] byArray2 = (byte[])this.NODES.get(i);
            for (int j = 0; j < byArray.length; ++j) {
                if (byArray[j] == byArray2[j]) continue;
                Interval interval = new Interval(i * n2, (int)Math.min((long)((i + 1) * n2 - 1), this.FILE_SIZE - 1L));
                arrayList.add((Object)interval);
                if (!LOG.isDebugEnabled()) continue block0;
                LOG.debug((Object)(Base32.encode(this.ROOT_HASH) + " -> found corrupted range: " + interval));
                continue block0;
            }
        }
        return arrayList;
    }

    public String httpStringValue() {
        return this.THEX_URI + ";" + Base32.encode(this.ROOT_HASH);
    }

    public boolean isGoodDepth() {
        return this.DEPTH == HashTree.calculateDepth(this.FILE_SIZE);
    }

    public boolean isDepthGoodEnough() {
        return this.DEPTH >= HashTree.calculateDepth(this.FILE_SIZE);
    }

    public boolean isBetterTree(HashTree hashTree) {
        int n;
        if (hashTree == null) {
            return true;
        }
        if (hashTree.isGoodDepth()) {
            return false;
        }
        if (this.isGoodDepth()) {
            return true;
        }
        int n2 = HashTree.calculateDepth(this.FILE_SIZE);
        int n3 = Math.abs(this.DEPTH - n2);
        return n3 < (n = Math.abs(hashTree.DEPTH - n2));
    }

    public long getFileSize() {
        return this.FILE_SIZE;
    }

    public String getRootHash() {
        return Base32.encode(this.ROOT_HASH);
    }

    public String getThexURI() {
        return this.THEX_URI;
    }

    public int getDepth() {
        return this.DEPTH;
    }

    public List getNodes() {
        return this.NODES;
    }

    public int getNodeCount() {
        double d = this.NODES.size();
        int n = (int)d;
        for (int i = this.DEPTH - 1; i >= 0; --i) {
            d = Math.ceil(d / 2.0);
            n += (int)d;
        }
        return n;
    }

    public List getAllNodes() {
        return HashTreeNodeManager.instance().getAllNodes(this);
    }

    public void write(OutputStream outputStream) throws IOException {
        this.getTreeWriter().write(outputStream);
    }

    public int getOutputLength() {
        return this.getTreeWriter().getLength();
    }

    public String getOutputType() {
        return this.getTreeWriter().getType();
    }

    public static int calculateDepth(long l) {
        if (l < 262144L) {
            return 0;
        }
        if (l < 524288L) {
            return 1;
        }
        if (l < 0x100000L) {
            return 2;
        }
        if (l < 0x200000L) {
            return 3;
        }
        if (l < 0x500000L) {
            return 4;
        }
        if (l < 0xA00000L) {
            return 5;
        }
        if (l < 0x1400000L) {
            return 6;
        }
        if (l < 0x3200000L) {
            return 7;
        }
        if (l < 0x6400000L) {
            return 8;
        }
        return 9;
    }

    private HashTreeHandler getTreeWriter() {
        if (this._treeWriter == null) {
            this._treeWriter = new HashTreeHandler(this);
        }
        return this._treeWriter;
    }

    static List createAllParentNodes(List list) {
        ArrayList arrayList = new ArrayList();
        arrayList.add((Object)Collections.unmodifiableList((List)list));
        while (list.size() > 1) {
            list = HashTree.createParentGeneration(list);
            arrayList.add(0, (Object)list);
        }
        return arrayList;
    }

    static List createParentGeneration(List list) {
        Tiger tiger = new Tiger();
        int n = list.size();
        n = n % 2 == 0 ? n / 2 : (n + 1) / 2;
        ArrayList arrayList = new ArrayList(n);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            byte[] byArray = (byte[])iterator.next();
            if (iterator.hasNext()) {
                byte[] byArray2 = (byte[])iterator.next();
                tiger.reset();
                tiger.update((byte)1);
                tiger.update(byArray, 0, byArray.length);
                tiger.update(byArray2, 0, byArray2.length);
                byte[] byArray3 = tiger.digest();
                arrayList.add((Object)byArray3);
                continue;
            }
            arrayList.add((Object)byArray);
        }
        return arrayList;
    }

    private static List createTTNodes(int n, long l, InputStream inputStream) throws IOException {
        ArrayList arrayList = new ArrayList((int)Math.ceil((double)l / (double)n));
        TigerTree tigerTree = new TigerTree();
        byte[] byArray = new byte[131072];
        long l2 = 0L;
        int n2 = 0;
        while (l2 < l) {
            int n3 = 0;
            long l3 = System.currentTimeMillis();
            tigerTree.reset();
            while (n3 < n && (n2 = inputStream.read(byArray)) != -1) {
                tigerTree.update(byArray, 0, n2);
                n3 += n2;
                l2 += (long)n2;
                try {
                    long l4 = (System.currentTimeMillis() - l3) * 2L;
                    if (l4 > 0L) {
                        Thread.sleep(l4);
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException("interrupted during hashing operation");
                }
                l3 = System.currentTimeMillis();
            }
            arrayList.add((Object)tigerTree.digest());
            if (l2 == l) {
                if (n2 == -1 || inputStream.read() == -1) continue;
                LOG.warn((Object)"More data than fileSize!");
                throw new IOException("unknown file size.");
            }
            if (n2 != -1 || l2 == l) continue;
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("couldn't hash whole file. read: " + n2 + ", offset: " + l2 + ", fileSize: " + l));
            }
            throw new IOException("couldn't hash whole file.");
        }
        return arrayList;
    }

    private static int log2Ceil(int n) {
        int n2 = 0;
        while (n > 1) {
            ++n;
            n >>>= 1;
            ++n2;
        }
        return n2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

