/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;

public class FixedSizeExpiringSet
implements Set,
Collection {
    private static final int DEFAULT_SIZE = 50;
    private static final long DEFAULT_EXPIRE_TIME = 600000L;
    private final int _maxSize;
    private final long _expireTime;
    private Map _map;

    public FixedSizeExpiringSet() {
        this(50);
    }

    public FixedSizeExpiringSet(int n) {
        this(n, 600000L);
    }

    public FixedSizeExpiringSet(int n, long l) {
        this._maxSize = n;
        this._expireTime = l;
        this._map = new HashMap();
    }

    public int size() {
        this.expire(false);
        return this._map.size();
    }

    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    public boolean contains(Object object) {
        Long l = (Long)this._map.get(object);
        if (l == null) {
            return false;
        }
        if (l < System.currentTimeMillis()) {
            this._map.remove(object);
            return false;
        }
        return true;
    }

    public Iterator iterator() {
        this.expire(false);
        return this._map.keySet().iterator();
    }

    public Object[] toArray() {
        this.expire(false);
        return this._map.keySet().toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        this.expire(false);
        return this._map.keySet().toArray(objectArray);
    }

    public boolean add(Object object) {
        if (object == null) {
            return false;
        }
        this.expire(this.size() >= this._maxSize);
        if (this._map.containsKey(object)) {
            return false;
        }
        this._map.put(object, (Object)new Long(System.currentTimeMillis() + this._expireTime));
        return true;
    }

    public boolean remove(Object object) {
        return this._map.remove(object) != null;
    }

    public boolean containsAll(Collection collection) {
        return this._map.keySet().containsAll(collection);
    }

    public boolean addAll(Collection collection) {
        if (collection.isEmpty()) {
            return false;
        }
        Iterator iterator = collection.iterator();
        for (int i = 0; i < this._maxSize && iterator.hasNext(); ++i) {
            this.add(iterator.next());
        }
        return true;
    }

    public boolean retainAll(Collection collection) {
        HashMap hashMap = new HashMap();
        boolean bl = false;
        Iterator iterator = this._map.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (collection.contains(object)) {
                hashMap.put(object, this._map.get(object));
                continue;
            }
            bl = true;
        }
        if (bl) {
            this._map = hashMap;
        }
        return bl;
    }

    public boolean removeAll(Collection collection) {
        if (collection.isEmpty()) {
            return false;
        }
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.remove(iterator.next());
        }
        return bl;
    }

    public void clear() {
        this._map.clear();
    }

    private void expire(boolean bl) {
        if (this._map.size() == 0) {
            return;
        }
        long l = System.currentTimeMillis();
        long l2 = Long.MAX_VALUE;
        Object object = null;
        HashSet hashSet = new HashSet();
        Iterator iterator = this._map.keySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = iterator.next();
            Long l3 = (Long)this._map.get(object2);
            long l4 = l3;
            if (l4 < l) {
                hashSet.add(object2);
                bl = false;
                continue;
            }
            if (!bl || l4 >= l2) continue;
            l2 = l4;
            object = object2;
        }
        if (hashSet.size() > 0) {
            this.removeAll((Collection)hashSet);
        }
        if (bl) {
            this.remove(object);
        }
    }
}

