/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.IpPort;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class NetworkUtils {
    private static final byte[] INVALID_ADDRESSES_BYTE = new byte[]{0, -1};
    private static final int[][] PRIVATE_ADDRESSES_BYTE = new int[][]{{-16777216, 0}, {-16777216, 0x7F000000}, {-16777216, -16777216}, {-16777216, 0xA000000}, {-1048576, -1408237568}, {-65536, -1442971648}, {-65536, -1062731776}};
    private static final byte LOCAL_ADDRESS_BYTE = 127;

    private NetworkUtils() {
    }

    public static boolean isValidAddressAndPort(byte[] byArray, int n) {
        return NetworkUtils.isValidAddress(byArray) && NetworkUtils.isValidPort(n);
    }

    public static boolean isValidAddressAndPort(String string, int n) {
        return NetworkUtils.isValidAddress(string) && NetworkUtils.isValidPort(n);
    }

    public static boolean isValidPort(int n) {
        if ((n & 0xFFFF0000) != 0) {
            return false;
        }
        return n != 0;
    }

    public static boolean isValidAddress(byte[] byArray) {
        return byArray[0] != INVALID_ADDRESSES_BYTE[0] && byArray[0] != INVALID_ADDRESSES_BYTE[1];
    }

    public static boolean isValidAddress(InetAddress inetAddress) {
        return NetworkUtils.isValidAddress(inetAddress.getAddress());
    }

    public static boolean isValidAddress(String string) {
        try {
            return NetworkUtils.isValidAddress(InetAddress.getByName(string));
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public static boolean isLocalAddress(InetAddress inetAddress) {
        try {
            if (inetAddress.getAddress()[0] == 127) {
                return true;
            }
            InetAddress inetAddress2 = InetAddress.getLocalHost();
            return Arrays.equals((byte[])inetAddress2.getAddress(), (byte[])inetAddress.getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public static boolean isCloseIP(byte[] byArray, byte[] byArray2) {
        return byArray[0] == byArray2[0];
    }

    public static boolean isVeryCloseIP(byte[] byArray, byte[] byArray2) {
        if (NetworkUtils.isPrivateAddress(byArray)) {
            return false;
        }
        return byArray[0] == byArray2[0] && byArray[1] == byArray2[1];
    }

    public static boolean isVeryCloseIP(byte[] byArray) {
        return NetworkUtils.isVeryCloseIP(RouterService.getAddress(), byArray);
    }

    public static boolean isPrivate() {
        return NetworkUtils.isPrivateAddress(RouterService.getAddress());
    }

    public static boolean isPrivateAddress(byte[] byArray) {
        if (!ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return false;
        }
        int n = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16;
        for (int i = 0; i < 7; ++i) {
            if ((n & PRIVATE_ADDRESSES_BYTE[i][0]) != PRIVATE_ADDRESSES_BYTE[i][1]) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrivateAddress(InetAddress inetAddress) {
        return NetworkUtils.isPrivateAddress(inetAddress.getAddress());
    }

    public static boolean isPrivateAddress(String string) {
        try {
            return NetworkUtils.isPrivateAddress(InetAddress.getByName(string));
        }
        catch (UnknownHostException unknownHostException) {
            return true;
        }
    }

    public static final String ip2string(byte[] byArray) {
        return NetworkUtils.ip2string(byArray, 0);
    }

    public static final String ip2string(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(ByteOrder.ubyte2int(byArray[n]));
        stringBuffer.append('.');
        stringBuffer.append(ByteOrder.ubyte2int(byArray[n + 1]));
        stringBuffer.append('.');
        stringBuffer.append(ByteOrder.ubyte2int(byArray[n + 2]));
        stringBuffer.append('.');
        stringBuffer.append(ByteOrder.ubyte2int(byArray[n + 3]));
        return stringBuffer.toString();
    }

    public static boolean isMe(String string, int n) {
        byte[] byArray;
        try {
            byArray = InetAddress.getByName(string).getAddress();
        }
        catch (IOException iOException) {
            return false;
        }
        return NetworkUtils.isMe(byArray, n);
    }

    public static boolean isMe(byte[] byArray, int n) {
        if (byArray[0] == 127) {
            return n == RouterService.getPort();
        }
        byte[] byArray2 = RouterService.getAddress();
        return n == RouterService.getPort() && Arrays.equals((byte[])byArray, (byte[])byArray2);
    }

    public static byte[] packIpPorts(Collection collection) {
        byte[] byArray = new byte[collection.size() * 6];
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            IpPort ipPort = (IpPort)iterator.next();
            byte[] byArray2 = ipPort.getInetAddress().getAddress();
            int n2 = ipPort.getPort();
            System.arraycopy(byArray2, 0, byArray, n, 4);
            ByteOrder.short2leb((short)n2, byArray, n += 4);
            n += 2;
        }
        return byArray;
    }

    public static List unpackIps(byte[] byArray) throws BadPacketException {
        if (byArray.length % 6 != 0) {
            throw new BadPacketException("invalid size");
        }
        int n = byArray.length / 6;
        ArrayList arrayList = new ArrayList(n);
        byte[] byArray2 = new byte[6];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(byArray, i * 6, byArray2, 0, 6);
            arrayList.add((Object)QueryReply.IPPortCombo.getCombo(byArray2));
        }
        return Collections.unmodifiableList((List)arrayList);
    }

    public static InetAddress getByAddress(byte[] byArray) throws UnknownHostException {
        String string = NetworkUtils.ip2string(byArray);
        return InetAddress.getByName(string);
    }

    public static boolean isValidExternalIpPort(IpPort ipPort) {
        if (ipPort == null) {
            return false;
        }
        return NetworkUtils.isValidAddress(ipPort.getAddress()) && !NetworkUtils.isPrivateAddress(ipPort.getAddress()) && NetworkUtils.isValidPort(ipPort.getPort());
    }
}

