/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ErrorService;
import com.sun.java.util.collections.Comparable;

class SimpleTimerTask
implements Comparable {
    private final Runnable _task;
    private final long _period;
    private long _nextTime;

    SimpleTimerTask(Runnable runnable, long l, long l2) {
        this._task = runnable;
        this._period = l;
        this._nextTime = l2;
    }

    public long timeUntilExecution() {
        return this._nextTime - System.currentTimeMillis();
    }

    public boolean runAndReschedule() {
        try {
            this._task.run();
        }
        catch (Exception exception) {
            ErrorService.error(exception);
        }
        if (this._period == 0L) {
            return false;
        }
        this._nextTime = System.currentTimeMillis() + this._period;
        return true;
    }

    public int compareTo(Object object) {
        long l = ((SimpleTimerTask)object)._nextTime - this._nextTime;
        return ByteOrder.long2int(l);
    }
}

