/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.util.CommonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Properties;

public class LimeXMLProperties {
    public static final long DEFAULT_NONFILE_INDEX = 0xFFFFFFFFL;
    private Properties _properties = new Properties();
    private static LimeXMLProperties _instance = new LimeXMLProperties();
    private static final String XML_PROPS_FILENAME = "xml.props";
    private static final String XML_SCHEMA_DIR = "XML_SCHEMA_DIR";
    private static final String XML_IMAGES_DIR = "XML_IMAGES_DIR";
    private static final String XML_DOCS_DIR = "XML_DOCS_DIR";
    private static final String XML_DISPLAY_PROPS_DIR = "XML_DISPLAY_PROPS_DIR";
    private static final String XML_SCHEMA_DIR_DEF = "xml" + File.separator + "schemas" + File.separator;
    private static final String XML_IMAGES_DIR_DEF = "xml" + File.separator + "misc" + File.separator;
    private static final String XML_DOCS_DIR_DEF = "xml" + File.separator + "data" + File.separator;
    private static final String XML_DISPLAY_PROPS_DIR_DEF = "xml" + File.separator + "display" + File.separator;
    private static final String USER_MAP_FILE = "USER_MAP_FILE";
    private static final String USER_MAP_FILE_DEF = "UserMap.dat";

    private LimeXMLProperties() {
        this.loadProperties();
    }

    protected void loadProperties() {
        try {
            this._properties.load(new FileInputStream(this.getPath() + XML_PROPS_FILENAME));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static LimeXMLProperties instance() {
        return _instance;
    }

    public String getXMLSchemaDir() {
        return CommonUtils.getCurrentDirectory().getAbsolutePath();
    }

    public String getXMLImagesDir() {
        String string = this._properties.getProperty(XML_IMAGES_DIR, XML_IMAGES_DIR_DEF);
        return this.getPath() + string;
    }

    public String getXMLDocsDir() {
        String string = this._properties.getProperty(XML_DOCS_DIR, XML_DOCS_DIR_DEF);
        return this.getPath() + string;
    }

    public String getXMLDisplayPropsDir() {
        String string = this._properties.getProperty(XML_DISPLAY_PROPS_DIR, XML_DISPLAY_PROPS_DIR_DEF);
        return this.getPath() + string;
    }

    public File[] getAllXMLSchemaFiles() {
        File file = new File(this.getXMLSchemaDir());
        String[] stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".xsd");
            }
        });
        if (stringArray == null || stringArray.length == 0) {
            return new File[0];
        }
        int n = stringArray.length;
        File[] fileArray = new File[n];
        for (int i = 0; i < n; ++i) {
            fileArray[i] = new File(file, stringArray[i]);
        }
        return fileArray;
    }

    public String getUserMapFile() {
        String string = this._properties.getProperty(USER_MAP_FILE, USER_MAP_FILE_DEF);
        return this.getPath() + string;
    }

    public String getPath() {
        String string = System.getProperty("LIME_HOME");
        if (string == null || string.trim().equals("")) {
            File file = CommonUtils.getUserSettingsDir();
            String string2 = file.getAbsolutePath();
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            return string2;
        }
        if (!string.endsWith("/") && !string.endsWith("\\")) {
            string = string + File.separator;
        }
        return string + "lib" + File.separator;
    }
}

