/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.xml.LimeXMLSchemaFieldExtractor;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LimeXMLSchema {
    private final List _canonicalizedFields;
    private final String _schemaURI;
    private final String _description;

    public LimeXMLSchema(File file) throws IOException {
        this(LimeXMLUtils.getInputSource(file));
    }

    public LimeXMLSchema(InputSource inputSource) throws IOException {
        Document document = this.getDocument(inputSource);
        this._canonicalizedFields = new LimeXMLSchemaFieldExtractor().getFields(document);
        this._schemaURI = LimeXMLSchema.retrieveSchemaURI(document);
        this._description = LimeXMLSchema.getDisplayString(this._schemaURI);
    }

    private Document getDocument(InputSource inputSource) throws IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("" + parserConfigurationException);
        }
        documentBuilder.setEntityResolver(new Resolver(inputSource));
        Document document = null;
        try {
            document = documentBuilder.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new IOException("" + sAXException);
        }
        return document;
    }

    private static String retrieveSchemaURI(Document document) {
        Element element = document.getDocumentElement();
        NamedNodeMap namedNodeMap = element.getAttributes();
        Node node = namedNodeMap.getNamedItem("targetNamespace");
        if (node != null) {
            return node.getNodeValue();
        }
        return "";
    }

    private void printNode(Node node) {
        if (node.getNodeType() == 1) {
            System.out.print("node = " + node.getNodeName() + " ");
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("name");
            if (node2 != null) {
                System.out.print(node2 + "");
            }
            System.out.println("");
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node3 = nodeList.item(i);
                this.printNode(node3);
            }
        }
    }

    public String getSchemaURI() {
        return this._schemaURI;
    }

    public List getCanonicalizedFields() {
        return Collections.unmodifiableList((List)this._canonicalizedFields);
    }

    public List getEnumerationFields() {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this._canonicalizedFields.iterator();
        while (iterator.hasNext()) {
            SchemaFieldInfo schemaFieldInfo = (SchemaFieldInfo)iterator.next();
            if (schemaFieldInfo.getEnumerationList() == null) continue;
            linkedList.add((Object)schemaFieldInfo);
        }
        return linkedList;
    }

    public Map getDefaultFieldEnumerativeValueMap() {
        HashMap hashMap = new HashMap();
        Iterator iterator = this._canonicalizedFields.iterator();
        while (iterator.hasNext()) {
            SchemaFieldInfo schemaFieldInfo = (SchemaFieldInfo)iterator.next();
            Map map = schemaFieldInfo.getDefaultEnumerativeValueMap();
            if (map == null) continue;
            hashMap.put((Object)schemaFieldInfo.getCanonicalizedFieldName(), (Object)map);
        }
        return hashMap;
    }

    public String[] getCanonicalizedFieldNames() {
        List list = this.getCanonicalizedFields();
        String[] stringArray = new String[list.size()];
        Iterator iterator = list.iterator();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((SchemaFieldInfo)iterator.next()).getCanonicalizedFieldName();
        }
        return stringArray;
    }

    public String getDescription() {
        return this._description;
    }

    public static String getDisplayString(String string) {
        int n = string.lastIndexOf("/");
        int n2 = string.lastIndexOf(".");
        String string2 = n == -1 || n2 == -1 ? string : string.substring(n + 1, n2);
        return string2;
    }

    private static final class Resolver
    implements EntityResolver {
        private InputSource schema;

        public Resolver(InputSource inputSource) {
            this.schema = inputSource;
        }

        public InputSource resolveEntity(String string, String string2) {
            return this.schema;
        }
    }
}

