/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.xml.LimeXMLProperties;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import java.io.File;
import java.io.IOException;

public class LimeXMLSchemaRepository {
    private Map _uriSchemaMap = new HashMap();
    private static LimeXMLSchemaRepository _instance = new LimeXMLSchemaRepository();

    private LimeXMLSchemaRepository() {
        this.initialize();
    }

    protected void initialize() {
        File[] fileArray = LimeXMLProperties.instance().getAllXMLSchemaFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                try {
                    LimeXMLSchema limeXMLSchema = new LimeXMLSchema(fileArray[i]);
                    this._uriSchemaMap.put((Object)limeXMLSchema.getSchemaURI(), (Object)limeXMLSchema);
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static LimeXMLSchemaRepository instance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LimeXMLSchema getSchema(String string) {
        Map map = this._uriSchemaMap;
        synchronized (map) {
            return (LimeXMLSchema)this._uriSchemaMap.get((Object)string);
        }
    }

    public Collection getAvailableSchemas() {
        return Collections.unmodifiableCollection((Collection)this._uriSchemaMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAvailableSchemaURIs() {
        Object[] objectArray;
        Map map = this._uriSchemaMap;
        synchronized (map) {
            Set set = this._uriSchemaMap.keySet();
            objectArray = (String[])set.toArray((Object[])new String[0]);
        }
        Arrays.sort((Object[])objectArray, (Comparator)new Comparator(){

            public int compare(Object object, Object object2) {
                String string = (String)object;
                String string2 = (String)object2;
                return string.compareTo(string2);
            }
        });
        return objectArray;
    }
}

