/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LimeXMLUtils {
    private static final double MATCHING_RATE = 0.9;
    private static final String C_HEADER_BEGIN = "{";
    private static final String C_HEADER_END = "}";
    private static final String C_HEADER_NONE_VAL = "plaintext";
    private static final String C_HEADER_ZLIB_VAL = "deflate";
    private static final String C_HEADER_GZIP_VAL = "gzip";
    private static final String COMPRESS_HEADER_ZLIB = "{deflate}";
    private static final String COMPRESS_HEADER_GZIP = "{gzip}";
    private static final String COMPRESS_HEADER_NONE = "{}";
    private static final int NONE = 0;
    private static final int GZIP = 1;
    private static final int ZLIB = 2;
    public static final String AUDIO_BITRATE_ATTR = "audios__audio__bitrate__";
    private static final int NUM_BYTES_TO_HASH = 100;
    private static final int NUM_TOTAL_HASH = 300;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InputSource getInputSource(File file) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            while (string != null) {
                string = bufferedReader.readLine();
                if (string == null) continue;
                stringBuffer.append(string + "\n");
            }
            Object var5_4 = null;
            if (bufferedReader == null) return new InputSource(new StringReader(stringBuffer.toString()));
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (bufferedReader == null) throw throwable;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
        return new InputSource(new StringReader(stringBuffer.toString()));
    }

    public static Document getDocument(File file) throws IOException, ParserConfigurationException, SAXException {
        InputSource inputSource = LimeXMLUtils.getInputSource(file);
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.parse(inputSource);
        return document;
    }

    public static String getAttributeValue(NamedNodeMap namedNodeMap, String string) {
        Node node = namedNodeMap.getNamedItem(string);
        if (node == null) {
            return null;
        }
        return node.getNodeValue();
    }

    public static List getElements(NodeList nodeList) {
        ArrayList arrayList = new ArrayList(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            arrayList.add((Object)node);
        }
        return arrayList;
    }

    public static List getAttributes(NamedNodeMap namedNodeMap) {
        ArrayList arrayList = new ArrayList(namedNodeMap.getLength());
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            arrayList.add((Object)node);
        }
        return arrayList;
    }

    public static String getText(NodeList nodeList) {
        StringBuffer stringBuffer = new StringBuffer();
        block4: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    stringBuffer.append(node.getNodeValue());
                    continue block4;
                }
                case 5: {
                    if (node.getNodeName().equals("amp")) {
                        stringBuffer.append('&');
                        continue block4;
                    }
                    if (node.getNodeName().equals("lt")) {
                        stringBuffer.append('<');
                        continue block4;
                    }
                    if (node.getNodeName().equals("gt")) {
                        stringBuffer.append('>');
                        continue block4;
                    }
                    if (node.getNodeName().equals("apos")) {
                        stringBuffer.append('\'');
                        continue block4;
                    }
                    if (!node.getNodeName().equals("quot")) continue block4;
                    stringBuffer.append('\"');
                    continue block4;
                }
            }
        }
        return stringBuffer.toString();
    }

    public static void writeEscapedString(Writer writer, String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                writer.write("&lt;");
                continue;
            }
            if (c == '>') {
                writer.write("&gt;");
                continue;
            }
            if (c == '&') {
                writer.write("&amp;");
                continue;
            }
            if (c == '\'') {
                writer.write("&apos;");
                continue;
            }
            if (c == '\"') {
                writer.write("&quot;");
                continue;
            }
            writer.write(c);
        }
    }

    public static Response createResponse(String string) {
        return new Response(0xFFFFFFFFL, (long)string.length(), "xml result", string);
    }

    public static byte[] readFully(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static boolean match(LimeXMLDocument limeXMLDocument, LimeXMLDocument limeXMLDocument2) {
        if (limeXMLDocument == null) {
            return false;
        }
        if (limeXMLDocument2 == null) {
            throw new NullPointerException("querying with null doc.");
        }
        Set set = limeXMLDocument2.getNameValueSet();
        int n = set.size();
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            Assert.that(string2 != null, "null value");
            if (string2.equals("")) continue;
            String string3 = limeXMLDocument.getValue(string);
            if (string3 == null || string3.equals("")) {
                ++n3;
                continue;
            }
            try {
                double d;
                double d2 = new Double(string3);
                if (d2 != (d = new Double(string2).doubleValue())) continue;
                ++n2;
                if (!string.equals(AUDIO_BITRATE_ATTR)) continue;
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                String string4 = string2.toLowerCase(Locale.US);
                String string5 = I18NConvert.instance().getNorm(string3);
                if (!string5.startsWith(string4)) continue;
                ++n2;
            }
        }
        double d = n;
        double d3 = n2;
        double d4 = n3;
        if (n > 1) {
            if (bl) {
                d -= 1.0;
                d3 -= 1.0;
                --n2;
            }
            if ((d4 + d3) / d < 0.9) {
                return false;
            }
            return n2 > 0;
        }
        if (n == 1) {
            return !(d3 / d < 1.0);
        }
        return false;
    }

    public static boolean isMP3File(String string) {
        boolean bl = false;
        if ((string = string.toLowerCase(Locale.US)).endsWith(".mp3")) {
            bl = true;
        }
        return bl;
    }

    public static boolean isMP3File(File file) {
        boolean bl = LimeXMLUtils.isMP3File(file.getName());
        return bl;
    }

    public static Response[] getResponseArray(List list) {
        Response[] responseArray = new Response[list.size()];
        Iterator iterator = list.iterator();
        for (int i = 0; iterator.hasNext() && i < responseArray.length; ++i) {
            String string = "";
            try {
                string = ((LimeXMLDocument)iterator.next()).getXMLString();
            }
            catch (SchemaNotFoundException schemaNotFoundException) {
                ErrorService.error(schemaNotFoundException);
            }
            responseArray[i] = LimeXMLUtils.createResponse(string);
        }
        return responseArray;
    }

    public static String encodeXML(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(38) == -1 && string.indexOf(60) == -1 && string.indexOf(62) == -1 && string.indexOf(39) == -1 && string.indexOf(34) == -1) {
            return string;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(2 * n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            if (c == '\'') {
                stringBuffer.append("&apos;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String capitalizeFirst(String string) {
        String string2 = string.substring(0, 1).toUpperCase(Locale.US);
        String string3 = string.substring(1);
        String string4 = string2 + string3;
        return string4.replace('_', ' ');
    }

    public static String processColName(String string) {
        int n;
        if (string.endsWith("__")) {
            string = string.substring(0, string.lastIndexOf("__"));
        }
        if ((n = string.lastIndexOf("__")) == -1) {
            return string;
        }
        return LimeXMLUtils.capitalizeFirst(string.substring(n += "__".length()));
    }

    public static byte[] compress(byte[] byArray) {
        byte[] byArray2 = null;
        if (LimeXMLUtils.shouldCompress(byArray)) {
            byArray2 = LimeXMLUtils.compressZLIB(byArray);
        }
        byte[] byArray3 = null;
        if (byArray2 != null) {
            byArray3 = new byte[COMPRESS_HEADER_ZLIB.length() + byArray2.length];
            System.arraycopy(COMPRESS_HEADER_ZLIB.getBytes(), 0, byArray3, 0, COMPRESS_HEADER_ZLIB.length());
            System.arraycopy(byArray2, 0, byArray3, COMPRESS_HEADER_ZLIB.length(), byArray2.length);
        } else {
            byArray3 = new byte[COMPRESS_HEADER_NONE.length() + byArray.length];
            System.arraycopy(COMPRESS_HEADER_NONE.getBytes(), 0, byArray3, 0, COMPRESS_HEADER_NONE.length());
            System.arraycopy(byArray, 0, byArray3, COMPRESS_HEADER_NONE.length(), byArray.length);
        }
        return byArray3;
    }

    private static boolean shouldCompress(byte[] byArray) {
        return byArray.length >= 1000;
    }

    private static byte[] compressZLIB(byte[] byArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
            deflaterOutputStream.write(byArray, 0, byArray.length);
            ((FilterOutputStream)deflaterOutputStream).flush();
            deflaterOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            Assert.that(false, "Couldn't write to byte stream");
            return null;
        }
    }

    public static byte[] uncompress(byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[]{};
        String string = new String(byArray, 0, C_HEADER_BEGIN.length());
        if (string.equals(C_HEADER_BEGIN)) {
            int n;
            boolean bl = false;
            for (n = 0; n < byArray.length && !bl; ++n) {
                if (byArray[n] != 125) continue;
                bl = true;
            }
            string = new String(byArray, 1, n - 1 - 1);
            int n2 = LimeXMLUtils.getCompressionType(string);
            if (n2 == 0) {
                byArray2 = new byte[byArray.length - (string.length() + 2)];
                System.arraycopy(byArray, n, byArray2, 0, byArray.length - (string.length() + 2));
            } else if (n2 == 1) {
                byArray2 = new byte[byArray.length - COMPRESS_HEADER_GZIP.length()];
                System.arraycopy(byArray, COMPRESS_HEADER_GZIP.length(), byArray2, 0, byArray.length - COMPRESS_HEADER_GZIP.length());
                byArray2 = LimeXMLUtils.uncompressGZIP(byArray2);
            } else if (n2 == 2) {
                byArray2 = new byte[byArray.length - COMPRESS_HEADER_ZLIB.length()];
                System.arraycopy(byArray, COMPRESS_HEADER_ZLIB.length(), byArray2, 0, byArray.length - COMPRESS_HEADER_ZLIB.length());
                byArray2 = LimeXMLUtils.uncompressZLIB(byArray2);
            }
        } else {
            return byArray;
        }
        return byArray2;
    }

    private static int getCompressionType(String string) {
        String string2 = string.trim();
        if (string2.equals("") || string2.equalsIgnoreCase(C_HEADER_NONE_VAL)) {
            return 0;
        }
        if (string2.equalsIgnoreCase(C_HEADER_GZIP_VAL)) {
            return 1;
        }
        if (string2.equalsIgnoreCase(C_HEADER_ZLIB_VAL)) {
            return 2;
        }
        return -1;
    }

    private static byte[] uncompressGZIP(byte[] byArray) throws IOException {
        int n;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = gZIPInputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] uncompressZLIB(byte[] byArray) throws IOException {
        int n;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inflaterInputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static void clearHashBytes(byte[] byArray) {
        for (int i = 0; i < 100; ++i) {
            byArray[i] = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] hashFile(File file) throws IOException {
        byte[] byArray = null;
        FileInputStream fileInputStream = null;
        byte[] byArray2 = new byte[100];
        try {
            fileInputStream = new FileInputStream(file);
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Assert.that(false, "no sha algorithm.");
            }
            long l = file.length();
            if (l < 300L) {
                int n = 0;
                do {
                    LimeXMLUtils.clearHashBytes(byArray2);
                    n = fileInputStream.read(byArray2);
                    messageDigest.update(byArray2);
                    if (file.length() == l) continue;
                    throw new IOException("invalid length");
                } while (n == 100);
            } else {
                long l2 = l / 3L;
                LimeXMLUtils.clearHashBytes(byArray2);
                fileInputStream.read(byArray2);
                messageDigest.update(byArray2);
                if (file.length() != l) {
                    throw new IOException("invalid length");
                }
                LimeXMLUtils.clearHashBytes(byArray2);
                fileInputStream.skip(l2 - 100L);
                fileInputStream.read(byArray2);
                messageDigest.update(byArray2);
                if (file.length() != l) {
                    throw new IOException("invalid length");
                }
                LimeXMLUtils.clearHashBytes(byArray2);
                fileInputStream.skip(file.length() - (l2 + 100L) - 100L);
                fileInputStream.read(byArray2);
                messageDigest.update(byArray2);
                if (file.length() != l) {
                    throw new IOException("invalid length");
                }
            }
            byArray = messageDigest.digest();
            Object var10_9 = null;
            if (fileInputStream == null) return byArray;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (fileInputStream == null) throw throwable;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
        return byArray;
    }

    public static boolean notValidXML(String string) {
        return string == null || string.trim().equals("") || !string.startsWith("<?xml version=\"1.0\"?>");
    }
}

