/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cabos;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import java.util.Locale;
import jp.sourceforge.cabos.AqEventHandler;
import jp.sourceforge.cabos.AqMain;
import jp.sourceforge.cabos.AqResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AqEvent {
    private static final Log LOG = LogFactory.getLog((Class)(class$jp$sourceforge$cabos$AqEvent == null ? (class$jp$sourceforge$cabos$AqEvent = AqEvent.class$("jp.sourceforge.cabos.AqEvent")) : class$jp$sourceforge$cabos$AqEvent));
    private static final Map stateCache = new HashMap();
    private static int currentLocalIndex = -1;
    private static final String kSep = "<aq/>";
    protected static final int kLWEventQueryResult = 1;
    protected static final int kLWEventConnectionInitialized = 2;
    protected static final int kLWEventConnectionClosed = 3;
    protected static final int kLWEventConnectionsUpdated = 4;
    protected static final int kLWEventAddDownload = 5;
    protected static final int kLWEventRemoveDownload = 6;
    protected static final int kLWEventUpdateDownloadStats = 7;
    protected static final int kLWEventDownloadsUpdated = 8;
    protected static final int kLWEventAddUpload = 9;
    protected static final int kLWEventRemoveUpload = 10;
    protected static final int kLWEventUpdateUploadStats = 11;
    protected static final int kLWEventUploadsUpdated = 12;
    protected static final int kLWEventAddSharedFile = 13;
    protected static final int kLWEventBrowseHostFailed = 14;
    protected static final int kLWEventCoreConnected = 98;
    protected static final int kLWEventCoreInitialized = 99;
    static /* synthetic */ Class class$jp$sourceforge$cabos$AqEvent;

    private static String decodeValue(String string) {
        if (string == null) {
            return "";
        }
        if (string.length() == 0) {
            return string;
        }
        string = StringUtils.replace(string, "&amp;", "&");
        string = StringUtils.replace(string, "&lt;", "<");
        string = StringUtils.replace(string, "&gt;", ">");
        string = StringUtils.replace(string, "&apos;", "'");
        string = StringUtils.replace(string, "&quot;", "\"");
        return string;
    }

    private static String fixValue(String string) {
        return string != null ? string : "";
    }

    private static String fixUserAgent(String string) {
        if (string == null) {
            return "";
        }
        if (string.indexOf("Cabos") == -1 && string.indexOf("Acqlite") == -1) {
            return string;
        }
        return string.substring(string.indexOf("(") + 1, string.indexOf(")"));
    }

    protected static void signalEvent(int n) {
        AqEvent.signalEvent(n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void signalEvent(int n, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        Thread.yield();
        Class clazz = class$jp$sourceforge$cabos$AqEvent == null ? (class$jp$sourceforge$cabos$AqEvent = AqEvent.class$("jp.sourceforge.cabos.AqEvent")) : class$jp$sourceforge$cabos$AqEvent;
        synchronized (clazz) {
            switch (n) {
                case 1: {
                    String string;
                    String string2;
                    String string3;
                    String string4;
                    String string5;
                    Object object2;
                    AqResponse aqResponse = (AqResponse)object;
                    RemoteFileDesc remoteFileDesc = aqResponse.getRFD();
                    HostData hostData = aqResponse.getData();
                    Set set = aqResponse.getLocs();
                    GUID gUID = new GUID(hostData.getMessageGUID());
                    if (!AqEventHandler.queries.containsKey((Object)gUID)) {
                        return;
                    }
                    Integer n2 = (Integer)AqEventHandler.queries.get((Object)gUID);
                    int n3 = ++currentLocalIndex;
                    stringBuffer.append(n2);
                    stringBuffer.append(":");
                    stringBuffer.append(n3);
                    String string6 = stringBuffer.toString();
                    stringBuffer.setLength(0);
                    AqEventHandler.responses.put((Object)string6, (Object)aqResponse);
                    if (remoteFileDesc.getXMLDoc() != null) {
                        object2 = remoteFileDesc.getXMLDoc();
                        string5 = AqEvent.fixValue(((LimeXMLDocument)object2).getValue("audios__audio__bitrate__"));
                        string4 = AqEvent.fixValue(((LimeXMLDocument)object2).getValue("audios__audio__seconds__"));
                        string3 = AqEvent.decodeValue(((LimeXMLDocument)object2).getValue("audios__audio__artist__"));
                        string2 = AqEvent.decodeValue(((LimeXMLDocument)object2).getValue("audios__audio__album__"));
                        string = AqEvent.decodeValue(((LimeXMLDocument)object2).getValue("audios__audio__title__"));
                    } else {
                        string5 = "";
                        string4 = "";
                        string3 = "";
                        string2 = "";
                        string = "";
                    }
                    stringBuffer.append(hostData.getIP());
                    stringBuffer.append(":");
                    stringBuffer.append(hostData.getPort());
                    object2 = stringBuffer.toString();
                    stringBuffer.setLength(0);
                    if (hostData.isBrowseHostEnabled()) {
                        AqEventHandler.hosts.put(object2, (Object)hostData);
                    }
                    boolean bl = set.size() > 10;
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(n2);
                    stringBuffer.append(kSep);
                    stringBuffer.append(n3);
                    stringBuffer.append(kSep);
                    stringBuffer.append(set.size());
                    stringBuffer.append(kSep);
                    stringBuffer.append((String)object2);
                    stringBuffer.append(kSep);
                    stringBuffer.append(hostData.isBrowseHostEnabled() ? 1 : 0);
                    stringBuffer.append(kSep);
                    stringBuffer.append(remoteFileDesc.getSHA1Urn());
                    stringBuffer.append(kSep);
                    stringBuffer.append(remoteFileDesc.getFileName());
                    stringBuffer.append(kSep);
                    stringBuffer.append(remoteFileDesc.getSpeed());
                    stringBuffer.append(kSep);
                    stringBuffer.append(remoteFileDesc.getSize());
                    stringBuffer.append(kSep);
                    stringBuffer.append(string5);
                    stringBuffer.append(kSep);
                    stringBuffer.append(string4);
                    stringBuffer.append(kSep);
                    stringBuffer.append(string3);
                    stringBuffer.append(kSep);
                    stringBuffer.append(string2);
                    stringBuffer.append(kSep);
                    stringBuffer.append(string);
                    stringBuffer.append(kSep);
                    stringBuffer.append(bl);
                    stringBuffer.append("\n");
                    break;
                }
                case 2: {
                    ManagedConnection managedConnection = (ManagedConnection)object;
                    String string = new Locale(managedConnection.getLocalePref(), "").getDisplayLanguage();
                    String string7 = managedConnection.isSupernodeClientConnection() ? "Leaf" : (managedConnection.isClientSupernodeConnection() ? "Ultrapeer" : (managedConnection.isSupernodeSupernodeConnection() ? "Peer" : "Standard"));
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedConnection.getAddress());
                    stringBuffer.append(":");
                    stringBuffer.append(managedConnection.getPort());
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedConnection.getUserAgent());
                    stringBuffer.append(kSep);
                    stringBuffer.append(string);
                    stringBuffer.append(kSep);
                    stringBuffer.append(string7);
                    stringBuffer.append("\n");
                    break;
                }
                case 3: {
                    ManagedConnection managedConnection = (ManagedConnection)object;
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedConnection.getAddress());
                    stringBuffer.append(":");
                    stringBuffer.append(managedConnection.getPort());
                    stringBuffer.append("\n");
                    break;
                }
                case 5: {
                    ManagedDownloader managedDownloader = (ManagedDownloader)object;
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.hashCode());
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.getFileName());
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.getState());
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.getContentLength());
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.getAmountRead());
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.getSHA1Urn());
                    stringBuffer.append("\n");
                    break;
                }
                case 6: {
                    ManagedDownloader managedDownloader = (ManagedDownloader)object;
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.hashCode());
                    stringBuffer.append("\n");
                    stateCache.remove((Object)new Integer(managedDownloader.hashCode()));
                    if (!managedDownloader.canceled() || managedDownloader.getFile() == null) break;
                    managedDownloader.getFile().delete();
                    break;
                }
                case 7: {
                    ManagedDownloader managedDownloader = (ManagedDownloader)object;
                    float f = managedDownloader.getMeasuredBandwidth() * 1024.0f;
                    float f2 = managedDownloader.getAverageBandwidth() * 1024.0f;
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.hashCode());
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.getState());
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.getContentLength());
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.getAmountRead());
                    stringBuffer.append(kSep);
                    stringBuffer.append(f);
                    stringBuffer.append(kSep);
                    stringBuffer.append(f2);
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.getActiveHostCount());
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.getBusyHostCount());
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.getPossibleHostCount());
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.getQueuedHostCount());
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.getFile() != null ? managedDownloader.getFile().getAbsolutePath() : "");
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.getActiveHostAddresses());
                    stringBuffer.append("\n");
                    Integer n4 = new Integer(managedDownloader.hashCode());
                    if (stringBuffer.toString().equals(stateCache.get((Object)n4))) {
                        stringBuffer = null;
                        break;
                    }
                    stateCache.put((Object)n4, (Object)stringBuffer.toString());
                    break;
                }
                case 9: {
                    Uploader uploader = (Uploader)object;
                    int n5 = uploader.isBrowseHostEnabled() && uploader.getGnutellaPort() != 0 ? 1 : 0;
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.hashCode());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getFileName());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getHost());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getGnutellaPort());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getUserAgent());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getState());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getFileSize());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getTotalAmountUploaded());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getFileDesc().getPath());
                    stringBuffer.append(kSep);
                    stringBuffer.append(n5);
                    stringBuffer.append("\n");
                    break;
                }
                case 10: {
                    Uploader uploader = (Uploader)object;
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.hashCode());
                    stringBuffer.append("\n");
                    stateCache.remove((Object)new Integer(uploader.hashCode()));
                    break;
                }
                case 11: {
                    float f;
                    Uploader uploader = (Uploader)object;
                    try {
                        f = uploader.getMeasuredBandwidth() * 1024.0f;
                    }
                    catch (InsufficientDataException insufficientDataException) {
                        f = 0.0f;
                    }
                    float f3 = uploader.getAverageBandwidth() * 1024.0f;
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.hashCode());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getState());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getFileSize());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getTotalAmountUploaded());
                    stringBuffer.append(kSep);
                    stringBuffer.append(f);
                    stringBuffer.append(kSep);
                    stringBuffer.append(f3);
                    stringBuffer.append("\n");
                    Integer n6 = new Integer(uploader.hashCode());
                    if (stringBuffer.toString().equals(stateCache.get((Object)n6))) {
                        stringBuffer = null;
                        break;
                    }
                    stateCache.put((Object)n6, (Object)stringBuffer.toString());
                    break;
                }
                case 13: {
                    FileDesc fileDesc = (FileDesc)object;
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(fileDesc.getSHA1Urn());
                    stringBuffer.append("\n");
                    break;
                }
                case 14: {
                    GUID gUID = (GUID)object;
                    if (!AqEventHandler.queries.containsKey((Object)gUID)) {
                        return;
                    }
                    Integer n7 = (Integer)AqEventHandler.queries.get((Object)gUID);
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(n7);
                    stringBuffer.append("\n");
                }
                default: {
                    stringBuffer.append(n);
                    stringBuffer.append("\n");
                }
            }
        }
        if (stringBuffer != null) {
            AqMain.writeEvent(stringBuffer.toString());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

