/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cabos;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import jp.sourceforge.cabos.AqDispatcher;
import jp.sourceforge.cabos.AqEvent;
import jp.sourceforge.cabos.AqEventHandler;
import jp.sourceforge.cabos.ConnectionUpdate;
import jp.sourceforge.cabos.DownloadRetry;
import jp.sourceforge.cabos.TransferUpdate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AqMain {
    private static final Log LOG = LogFactory.getLog((Class)(class$jp$sourceforge$cabos$AqMain == null ? (class$jp$sourceforge$cabos$AqMain = AqMain.class$("jp.sourceforge.cabos.AqMain")) : class$jp$sourceforge$cabos$AqMain));
    private static InputStreamReader reader = null;
    private static OutputStreamWriter writer = null;
    private static Socket socket = null;
    private static boolean isShuttingdown = false;
    static /* synthetic */ Class class$jp$sourceforge$cabos$AqMain;

    public static void main(String[] stringArray) {
        try {
            socket = new Socket("localhost", 1024);
            reader = new InputStreamReader(socket.getInputStream(), "UTF-8");
            writer = new OutputStreamWriter(socket.getOutputStream(), "UTF-8");
        }
        catch (Exception exception) {
            System.exit(0);
        }
        if (!CommonUtils.isJava118()) {
            System.exit(0);
        }
        AqEvent.signalEvent(98);
        if (CommonUtils.getUserHomeDir().exists()) {
            FileUtils.setWriteable(CommonUtils.getUserHomeDir());
        } else {
            CommonUtils.getUserHomeDir().mkdirs();
        }
        if (CommonUtils.getUserSettingsDir().exists()) {
            FileUtils.setWriteable(CommonUtils.getUserSettingsDir());
        } else {
            CommonUtils.getUserSettingsDir().mkdirs();
        }
        AqEvent.signalEvent(99);
        AqMain.readLoop();
        System.exit(0);
    }

    private static void readLoop() {
        LinkedList linkedList = new LinkedList();
        StringBuffer stringBuffer = new StringBuffer();
        while (!isShuttingdown) {
            int n;
            try {
                n = reader.read();
            }
            catch (IOException iOException) {
                LOG.error((Object)iOException);
                break;
            }
            char c = (char)n;
            if (c == '|' || c == '\n') {
                linkedList.add((Object)stringBuffer.toString());
                stringBuffer.setLength(0);
                if (c != '\n') continue;
                try {
                    AqDispatcher.dispatchCommand((List)linkedList);
                }
                catch (Throwable throwable) {
                    LOG.error((Object)throwable);
                    break;
                }
                linkedList.clear();
                continue;
            }
            if (c == '\r') continue;
            stringBuffer.append(c);
        }
    }

    protected static void start() {
        RouterService routerService = new RouterService(new AqEventHandler());
        routerService.start();
        RouterService.schedule(new ConnectionUpdate(), 60000L, 60000L);
        RouterService.schedule(new TransferUpdate(), 1000L, 1000L);
        RouterService.schedule(new DownloadRetry(), 3600000L, 3600000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeEvent(String string) {
        OutputStreamWriter outputStreamWriter = writer;
        synchronized (outputStreamWriter) {
            try {
                writer.write(string);
                writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void shutdown() {
        OutputStreamWriter outputStreamWriter = writer;
        synchronized (outputStreamWriter) {
            try {
                reader.close();
                writer.close();
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            isShuttingdown = true;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

