/*
 * Decompiled with CFR 0.152.
 */
package phex.common.address;

public class AddressUtils {
    public static byte[] parseIntIP(String string) {
        long l = Long.parseLong(string);
        byte[] byArray = new byte[]{(byte)(l >>> 24 & 0xFFL), (byte)(l >>> 16 & 0xFFL), (byte)(l >>> 8 & 0xFFL), (byte)(l & 0xFFL)};
        return byArray;
    }

    public static int parseDottedIpToInt(String string) {
        int n = string.indexOf(58);
        String string2 = n != -1 ? string.substring(0, n) : string;
        char[] cArray = string2.toCharArray();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c < '0' || c > '9') {
                throw new IllegalArgumentException("IP contains character: " + string2);
            }
            int n4 = 0;
            while (c != '.') {
                if (c < '0' || c > '9') {
                    throw new IllegalArgumentException("IP contains character: " + string2);
                }
                n4 = n4 * 10 + c - 48;
                if (++i >= cArray.length) break;
                c = cArray[i];
            }
            if (n4 > 255) {
                throw new IllegalArgumentException("Bogus ip value: " + string2);
            }
            n2 = (n2 << 8) + n4;
            ++n3;
        }
        if (n3 != 4 || string2.endsWith(".")) {
            throw new IllegalArgumentException("Bogus ip: " + string2);
        }
        return n2;
    }

    public static byte[] parseIP(String string) {
        try {
            int n = AddressUtils.parseDottedIpToInt(string);
            byte[] byArray = new byte[]{(byte)(n >>> 24 & 0xFF), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n & 0xFF)};
            return byArray;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }
}

