/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import org.apache.commons.httpclient.ConnectMethod;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpClient {
    private static final Log LOG;
    private HttpConnectionManager httpConnectionManager;
    private HttpState state;
    private long httpConnectionTimeout = 0L;
    private int timeoutInMilliseconds = 0;
    private int connectionTimeout = 0;
    private HostConfiguration hostConfiguration;
    private boolean strictMode = false;
    static /* synthetic */ Class class$org$apache$commons$httpclient$HttpClient;

    public HttpClient() {
        this(new SimpleHttpConnectionManager());
    }

    public HttpClient(HttpConnectionManager httpConnectionManager) {
        if (httpConnectionManager == null) {
            throw new IllegalArgumentException("httpConnectionManager cannot be null");
        }
        this.state = new HttpState();
        this.httpConnectionManager = httpConnectionManager;
        this.hostConfiguration = new HostConfiguration();
    }

    public synchronized HttpState getState() {
        return this.state;
    }

    public synchronized void setState(HttpState state) {
        this.state = state;
    }

    public synchronized void setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
    }

    public synchronized boolean isStrictMode() {
        return this.strictMode;
    }

    public synchronized void setTimeout(int newTimeoutInMilliseconds) {
        this.timeoutInMilliseconds = newTimeoutInMilliseconds;
    }

    public synchronized void setHttpConnectionFactoryTimeout(long timeout) {
        this.httpConnectionTimeout = timeout;
    }

    public synchronized void setConnectionTimeout(int newTimeoutInMilliseconds) {
        this.connectionTimeout = newTimeoutInMilliseconds;
    }

    public void startSession(String host, int port) {
        LOG.trace((Object)"enter HttpClient.startSession(String, int)");
        this.startSession(host, port, false);
    }

    public void startSession(String host, int port, boolean https) {
        LOG.trace((Object)"enter HttpClient.startSession(String, int, boolean)");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HttpClient.startSession(String,int,boolean): Host:" + host + " Port:" + port + " HTTPS:" + https));
        }
        this.hostConfiguration.setHost(host, port, https ? "https" : "http");
    }

    public void startSession(String host, int port, Credentials creds) {
        LOG.trace((Object)"enter HttpClient.startSession(String, int, Credentials)");
        this.startSession(host, port, creds, false);
    }

    public void startSession(String host, int port, Credentials creds, boolean https) {
        LOG.trace((Object)"enter HttpClient.startSession(String, int, Credentials, boolean)");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Starting HttpClient session Host:" + host + " Port:" + port + " Credentials:" + creds + " HTTPS:" + https));
        }
        this.getState().setCredentials(null, creds);
        this.hostConfiguration.setHost(host, port, https ? "https" : "http");
    }

    public void startSession(URI uri) throws URIException, IllegalStateException {
        String host;
        LOG.trace((Object)"enter HttpClient.startSession(URI)");
        String scheme = uri.getScheme();
        if (scheme == null) {
            LOG.error((Object)"no scheme to start a session");
            throw new IllegalStateException("no scheme to start a session");
        }
        Protocol protocol = Protocol.getProtocol(scheme);
        String userinfo = uri.getUserinfo();
        if (userinfo != null) {
            this.getState().setCredentials(null, new UsernamePasswordCredentials(userinfo));
        }
        if ((host = uri.getHost()) == null || host.length() == 0) {
            LOG.error((Object)"no host to start a session");
            throw new IllegalStateException("no host to start a session");
        }
        int port = uri.getPort();
        if (port == -1) {
            LOG.error((Object)"HttpURL or HttpsURL instance required");
            throw new IllegalStateException("HttpURL or HttpsURL instance required");
        }
        this.hostConfiguration.setHost(host, null, port, protocol);
    }

    public void startSession(URL url) throws IllegalArgumentException {
        LOG.trace((Object)"enter HttpClient.startSession(String, int, Credentials, boolean)");
        int port = url.getPort();
        Protocol protocol = Protocol.getProtocol(url.getProtocol());
        this.hostConfiguration.setHost(url.getHost(), null, port, protocol);
    }

    public void startSession(URL url, Credentials creds) throws IllegalArgumentException {
        LOG.trace((Object)"enter HttpClient.startSession(URL, Credentials)");
        this.getState().setCredentials(null, creds);
        this.startSession(url);
    }

    public void startSession(String host, int port, String proxyhost, int proxyport) {
        LOG.trace((Object)"enter HttpClient.startSession(String, int, String, int)");
        this.startSession(host, port, proxyhost, proxyport, false);
    }

    public void startSession(String host, int port, String proxyhost, int proxyport, boolean secure) {
        LOG.trace((Object)"enter HttpClient.startSession(String, int, String, int, boolean)");
        this.hostConfiguration.setHost(host, port, secure ? "https" : "http");
        this.hostConfiguration.setProxy(proxyhost, proxyport);
    }

    public int executeMethod(HttpMethod method) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpClient.executeMethod(HttpMethod)");
        return this.executeMethod(method.getHostConfiguration() != null ? method.getHostConfiguration() : this.getHostConfiguration(), method, null);
    }

    public int executeMethod(HostConfiguration hostConfiguration, HttpMethod method) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpClient.executeMethod(HostConfiguration,HttpMethod)");
        return this.executeMethod(hostConfiguration, method, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeMethod(HostConfiguration hostConfiguration, HttpMethod method, HttpState state) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpClient.executeMethod(HostConfiguration,HttpMethod,HttpState)");
        if (method == null) {
            throw new IllegalArgumentException("HttpMethod parameter may not be null");
        }
        int soTimeout = 0;
        boolean strictMode = false;
        int connectionTimeout = 0;
        long httpConnectionTimeout = 0L;
        HostConfiguration defaultHostConfiguration = null;
        HttpClient httpClient = this;
        synchronized (httpClient) {
            soTimeout = this.timeoutInMilliseconds;
            strictMode = this.strictMode;
            connectionTimeout = this.connectionTimeout;
            httpConnectionTimeout = this.httpConnectionTimeout;
            if (state == null) {
                state = this.getState();
            }
            defaultHostConfiguration = this.getHostConfiguration();
        }
        HostConfiguration methodConfiguration = new HostConfiguration(hostConfiguration);
        if (hostConfiguration != defaultHostConfiguration) {
            if (!methodConfiguration.isHostSet()) {
                methodConfiguration.setHost(defaultHostConfiguration.getHost(), defaultHostConfiguration.getVirtualHost(), defaultHostConfiguration.getPort(), defaultHostConfiguration.getProtocol());
            }
            if (!methodConfiguration.isProxySet() && defaultHostConfiguration.isProxySet()) {
                methodConfiguration.setProxy(defaultHostConfiguration.getProxyHost(), defaultHostConfiguration.getProxyPort());
            }
            if (!methodConfiguration.isSOCKSSet() && defaultHostConfiguration.isSOCKSSet()) {
                int ver = defaultHostConfiguration.getSOCKSVersion();
                String host = defaultHostConfiguration.getProxyHost();
                int port = defaultHostConfiguration.getProxyPort();
                String user = defaultHostConfiguration.getSOCKSUsername();
                String pass = defaultHostConfiguration.getSOCKSPassword();
                methodConfiguration.setSOCKSProxySettings(ver, host, port, user, pass);
            }
            if (methodConfiguration.getLocalAddress() == null && defaultHostConfiguration.getLocalAddress() != null) {
                methodConfiguration.setLocalAddress(defaultHostConfiguration.getLocalAddress());
            }
        }
        HttpConnectionManager connmanager = this.httpConnectionManager;
        if (state.getHttpConnectionManager() != null) {
            connmanager = state.getHttpConnectionManager();
        }
        HttpConnection connection = connmanager.getConnection(methodConfiguration, httpConnectionTimeout);
        try {
            method.setStrictMode(strictMode);
            if (!connection.isOpen()) {
                connection.setSoTimeout(soTimeout);
                connection.setConnectionTimeout(connectionTimeout);
                connection.open();
                if (connection.isProxied() && connection.isSecure()) {
                    method = new ConnectMethod(method);
                }
            }
        }
        catch (IOException e) {
            connection.releaseConnection();
            throw e;
        }
        catch (RuntimeException e) {
            connection.releaseConnection();
            throw e;
        }
        return method.execute(state, connection);
    }

    public void endSession() throws IOException {
    }

    public String getHost() {
        return this.hostConfiguration.getHost();
    }

    public int getPort() {
        return this.hostConfiguration.getPort();
    }

    public synchronized HostConfiguration getHostConfiguration() {
        return this.hostConfiguration;
    }

    public synchronized void setHostConfiguration(HostConfiguration hostConfiguration) {
        this.hostConfiguration = hostConfiguration;
    }

    public synchronized HttpConnectionManager getHttpConnectionManager() {
        return this.httpConnectionManager;
    }

    public synchronized void setHttpConnectionManager(HttpConnectionManager httpConnectionManager) {
        this.httpConnectionManager = httpConnectionManager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        block3: {
            LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$HttpClient == null ? (class$org$apache$commons$httpclient$HttpClient = HttpClient.class$("org.apache.commons.httpclient.HttpClient")) : class$org$apache$commons$httpclient$HttpClient));
            if (!LOG.isDebugEnabled()) break block3;
            try {
                LOG.debug((Object)("Java version: " + System.getProperty("java.version")));
                LOG.debug((Object)("Java vendor: " + System.getProperty("java.vendor")));
                LOG.debug((Object)("Java class path: " + System.getProperty("java.class.path")));
                LOG.debug((Object)("Operating system name: " + System.getProperty("os.name")));
                LOG.debug((Object)("Operating system architecture: " + System.getProperty("os.arch")));
                LOG.debug((Object)("Operating system version: " + System.getProperty("os.version")));
                Provider[] providers = Security.getProviders();
                int i = 0;
                while (i < providers.length) {
                    Provider provider = providers[i];
                    LOG.debug((Object)(provider.getName() + " " + provider.getVersion() + ": " + provider.getInfo()));
                    ++i;
                }
            }
            catch (SecurityException ignore) {}
        }
    }
}

