/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert;

import java.util.Collection;
import java.util.Iterator;
import javax.sound.sampled.AudioFormat;
import org.tritonus.sampled.convert.TFormatConversionProvider;
import org.tritonus.util.ArraySet;

public abstract class TSimpleFormatConversionProvider
extends TFormatConversionProvider {
    private Collection m_sourceEncodings = new ArraySet();
    private Collection m_targetEncodings = new ArraySet();
    private Collection m_sourceFormats;
    private Collection m_targetFormats;

    protected TSimpleFormatConversionProvider(Collection collection, Collection collection2) {
        this.m_sourceFormats = collection;
        this.m_targetFormats = collection2;
        TSimpleFormatConversionProvider.collectEncodings(this.m_sourceFormats, this.m_sourceEncodings);
        TSimpleFormatConversionProvider.collectEncodings(this.m_targetFormats, this.m_targetEncodings);
    }

    private static void collectEncodings(Collection collection, Collection collection2) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            AudioFormat audioFormat = (AudioFormat)iterator.next();
            collection2.add(audioFormat.getEncoding());
        }
    }

    public AudioFormat.Encoding[] getSourceEncodings() {
        return this.m_sourceEncodings.toArray(TFormatConversionProvider.EMPTY_ENCODING_ARRAY);
    }

    public AudioFormat.Encoding[] getTargetEncodings() {
        return this.m_targetEncodings.toArray(TFormatConversionProvider.EMPTY_ENCODING_ARRAY);
    }

    public boolean isSourceEncodingSupported(AudioFormat.Encoding encoding) {
        return this.m_sourceEncodings.contains(encoding);
    }

    public boolean isTargetEncodingSupported(AudioFormat.Encoding encoding) {
        return this.m_targetEncodings.contains(encoding);
    }

    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat audioFormat) {
        if (this.isAllowedSourceFormat(audioFormat)) {
            return this.getTargetEncodings();
        }
        return TFormatConversionProvider.EMPTY_ENCODING_ARRAY;
    }

    public AudioFormat[] getTargetFormats(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        if (this.isConversionSupported(encoding, audioFormat)) {
            return this.m_targetFormats.toArray(TFormatConversionProvider.EMPTY_FORMAT_ARRAY);
        }
        return TFormatConversionProvider.EMPTY_FORMAT_ARRAY;
    }

    protected boolean isAllowedSourceEncoding(AudioFormat.Encoding encoding) {
        return this.m_sourceEncodings.contains(encoding);
    }

    protected boolean isAllowedTargetEncoding(AudioFormat.Encoding encoding) {
        return this.m_targetEncodings.contains(encoding);
    }

    protected boolean isAllowedSourceFormat(AudioFormat audioFormat) {
        Iterator iterator = this.m_sourceFormats.iterator();
        while (iterator.hasNext()) {
            AudioFormat audioFormat2 = (AudioFormat)iterator.next();
            if (!audioFormat2.matches(audioFormat)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAllowedTargetFormat(AudioFormat audioFormat) {
        Iterator iterator = this.m_targetFormats.iterator();
        while (iterator.hasNext()) {
            AudioFormat audioFormat2 = (AudioFormat)iterator.next();
            if (!audioFormat2.matches(audioFormat)) continue;
            return true;
        }
        return false;
    }

    protected Collection getCollectionSourceEncodings() {
        return this.m_sourceEncodings;
    }

    protected Collection getCollectionTargetEncodings() {
        return this.m_targetEncodings;
    }

    protected Collection getCollectionSourceFormats() {
        return this.m_sourceFormats;
    }

    protected Collection getCollectionTargetFormats() {
        return this.m_targetFormats;
    }
}

