/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import org.jaudiotagger.tag.id3.Id3FieldType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ID3v22FieldKey {
    ARTIST("TP1", Id3FieldType.TEXT),
    ALBUM("TAL", Id3FieldType.TEXT),
    TITLE("TT2", Id3FieldType.TEXT),
    TRACK("TRK", Id3FieldType.TEXT),
    YEAR("TYE", Id3FieldType.TEXT),
    GENRE("TCO", Id3FieldType.TEXT),
    COMMENT("COM", Id3FieldType.TEXT),
    COPYRIGHT("TCR", Id3FieldType.TEXT),
    ALBUM_ARTIST("TP2", Id3FieldType.TEXT),
    COMPOSER("TCM", Id3FieldType.TEXT),
    GROUPING("TT1", Id3FieldType.TEXT),
    DISC_NO("TPA", Id3FieldType.TEXT),
    BPM("TBP", Id3FieldType.TEXT),
    ENCODER("TEN", Id3FieldType.TEXT),
    MUSICBRAINZ_ARTISTID("TXX", "MusicBrainz Artist Id", Id3FieldType.TEXT),
    MUSICBRAINZ_RELEASEID("TXX", "MusicBrainz Album Id", Id3FieldType.TEXT),
    MUSICBRAINZ_RELEASEARTISTID("TXX", "MusicBrainz Album Artist Id", Id3FieldType.TEXT),
    MUSICBRAINZ_TRACK_ID("UFI", "http://musicbrainz.org", Id3FieldType.TEXT),
    MUSICBRAINZ_DISC_ID("TXX", "MusicBrainz Disc Id", Id3FieldType.TEXT),
    MUSICIP_ID("TXX", "MusicIP PUID", Id3FieldType.TEXT),
    AMAZON_ID("TXX", "ASIN", Id3FieldType.TEXT),
    MUSICBRAINZ_RELEASE_STATUS("TXX", "MusicBrainz Album Status", Id3FieldType.TEXT),
    MUSICBRAINZ_RELEASE_TYPE("TXX", "MusicBrainz Album Type", Id3FieldType.TEXT),
    MUSICBRAINZ_RELEASE_COUNTRY("TXX", "MusicBrainz Album Release Country", Id3FieldType.TEXT),
    LYRICS("ULT", Id3FieldType.TEXT),
    IS_COMPILATION("TCP", Id3FieldType.TEXT),
    ARTIST_SORT("TSP", Id3FieldType.TEXT),
    ALBUM_ARTIST_SORT("TS2", Id3FieldType.TEXT),
    ALBUM_SORT("TSA", Id3FieldType.TEXT),
    TITLE_SORT("TST", Id3FieldType.TEXT),
    COMPOSER_SORT("TSC", Id3FieldType.TEXT),
    COVER_ART("PIC", Id3FieldType.BINARY);

    private String fieldName;
    private String frameId;
    private String subId;
    private Id3FieldType fieldType;

    private ID3v22FieldKey(String frameId, Id3FieldType fieldType) {
        this.frameId = frameId;
        this.fieldType = fieldType;
        this.fieldName = frameId;
    }

    private ID3v22FieldKey(String frameId, String subId, Id3FieldType fieldType) {
        this.frameId = frameId;
        this.subId = subId;
        this.fieldType = fieldType;
        this.fieldName = String.valueOf(frameId) + ":" + subId;
    }

    public Id3FieldType getFieldType() {
        return this.fieldType;
    }

    public String getFrameId() {
        return this.frameId;
    }

    public String getSubId() {
        return this.subId;
    }

    public String getFieldName() {
        return this.fieldName;
    }
}

