/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.ogg.util;

public class OggCRCFactory {
    private static long[] crc_lookup = new long[256];
    private static boolean init = false;

    public static void init() {
        int i = 0;
        while (i < 256) {
            long r = i << 24;
            int j = 0;
            while (j < 8) {
                r = (r & 0x80000000L) != 0L ? r << 1 ^ 0x4C11DB7L : (r <<= 1);
                ++j;
            }
            OggCRCFactory.crc_lookup[i] = r & 0xFFFFFFFFFFFFFFFFL;
            ++i;
        }
        init = true;
    }

    public boolean checkCRC(byte[] data, byte[] crc) {
        return new String(crc).equals(new String(OggCRCFactory.computeCRC(data)));
    }

    public static byte[] computeCRC(byte[] data) {
        if (!init) {
            OggCRCFactory.init();
        }
        long crc_reg = 0L;
        int i = 0;
        while (i < data.length) {
            int tmp = (int)(crc_reg >>> 24 & 0xFFL ^ (long)OggCRCFactory.u(data[i]));
            crc_reg = crc_reg << 8 ^ crc_lookup[tmp];
            crc_reg &= 0xFFFFFFFFFFFFFFFFL;
            ++i;
        }
        byte[] sum = new byte[]{(byte)(crc_reg & 0xFFL), (byte)(crc_reg >>> 8 & 0xFFL), (byte)(crc_reg >>> 16 & 0xFFL), (byte)(crc_reg >>> 24 & 0xFFL)};
        return sum;
    }

    private static int u(int n) {
        return n & 0xFF;
    }
}

