/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.desktop.internal.impl;

import java.io.File;
import java.net.URL;
import org.jdesktop.jdic.desktop.internal.impl.WinAPIWrapper;

public class WinUtility {
    private WinUtility() {
    }

    private static String getFileExtension(File file) {
        String string = file.toString().trim();
        if (string == null || string == "") {
            return null;
        }
        int n = string.lastIndexOf(File.separator);
        String string2 = string.substring(n + 1, string.length());
        if ((n = string2.lastIndexOf(".")) == -1 || n == string2.length() - 1) {
            return null;
        }
        String string3 = string2.substring(n, string2.length());
        return string3;
    }

    public static String getVerbCommand(File file, String string) {
        String string2 = WinUtility.getFileExtension(file);
        if (string2 == null) {
            return null;
        }
        return WinAPIWrapper.WinAssocQueryString(string2, string);
    }

    public static String getVerbCommand(URL uRL, String string) {
        String string2 = uRL.getProtocol().trim();
        if (string2.compareToIgnoreCase("file") == 0) {
            string2 = "http";
        }
        if (string2 == null) {
            return null;
        }
        return WinAPIWrapper.WinAssocQueryString(string2, string);
    }

    static String getDefaultMailer() {
        String string = WinAPIWrapper.WinRegQueryValueEx(-2147483646, "SOFTWARE\\Clients\\Mail", "");
        return string;
    }

    static String getMozMailerLocation(String string) {
        String string2 = WinAPIWrapper.WinRegQueryValueEx(-2147483646, "SOFTWARE\\Clients\\Mail\\" + string + "\\shell\\open\\command", "");
        int n = string2.toLowerCase().lastIndexOf(".exe");
        return string2.substring(string2.charAt(0) == '\"' ? 1 : 0, n + 4);
    }

    static boolean isMapiSupported() {
        String string = WinAPIWrapper.WinRegQueryValueEx(-2147483646, "SOFTWARE\\Microsoft\\Windows Messaging Subsystem", "MAPI");
        return string != null && string.equals("1");
    }
}

