/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Iterator;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleProperties;
import net.sourceforge.pmd.RuleSet;

public class RuleSetWriter {
    private PrintStream m_outputStream;
    private StringBuffer m_line = new StringBuffer(500);
    private int m_indent;

    public RuleSetWriter(OutputStream outputStream) {
        this.m_outputStream = new PrintStream(outputStream);
        this.m_line.append("<?xml version=\"1.0\" ?>");
        this.outputLine();
    }

    public void write(RuleSet ruleSet) {
        this.indent();
        this.setupNewLine();
        this.m_line.append("<ruleset name=\"");
        this.m_line.append(ruleSet.getName());
        this.m_line.append('\"');
        this.m_line.append(" include=\"");
        this.m_line.append(ruleSet.include() ? "true" : "false");
        this.m_line.append("\">");
        this.outputLine();
        this.indent();
        this.writeDescription(ruleSet.getDescription());
        this.outdent();
        Iterator rules = ruleSet.getRules().iterator();
        while (rules.hasNext()) {
            this.write((Rule)rules.next());
        }
        this.setupNewLine();
        this.m_line.append("</ruleset>");
        this.outputLine();
        this.outdent();
    }

    private void write(Rule rule) {
        this.m_outputStream.println("");
        this.indent();
        this.setupNewLine();
        this.m_line.append("<rule name=\"");
        this.m_line.append(rule.getName());
        this.m_line.append('\"');
        this.outputLine();
        this.m_indent += 6;
        this.setupNewLine();
        this.m_line.append("message=\"");
        this.m_line.append(rule.getMessage());
        this.m_line.append('\"');
        this.outputLine();
        this.setupNewLine();
        this.m_line.append("class=\"");
        this.m_line.append(rule.getClass().getName());
        this.m_line.append('\"');
        this.outputLine();
        this.setupNewLine();
        this.m_line.append("include=\"");
        this.m_line.append(rule.include() ? "true" : "false");
        this.m_line.append("\">");
        this.outputLine();
        this.m_indent -= 6;
        this.indent();
        this.writeDescription(rule.getDescription());
        this.outdent();
        this.indent();
        this.writeExample(rule.getExample());
        this.outdent();
        this.indent();
        this.writePriority(rule.getPriority());
        this.outdent();
        this.indent();
        this.writeProperties(rule);
        this.outdent();
        this.setupNewLine();
        this.m_line.append("</rule>");
        this.outputLine();
        this.outdent();
    }

    private void writeDescription(String description) {
        this.setupNewLine();
        this.m_line.append("<description>");
        this.outputLine();
        this.indent();
        this.setupNewLine();
        this.m_line.append(description);
        this.outputLine();
        this.outdent();
        this.setupNewLine();
        this.m_line.append("</description>");
        this.outputLine();
    }

    private void writeExample(String example) {
        this.setupNewLine();
        this.m_line.append("<example>");
        this.outputLine();
        this.indent();
        this.setupNewLineWithoutIndent();
        this.m_line.append("<![CDATA[");
        this.outputLine();
        this.setupNewLineWithoutIndent();
        this.m_line.append(example);
        this.outputLine();
        this.setupNewLineWithoutIndent();
        this.m_line.append("]]>");
        this.outputLine();
        this.outdent();
        this.setupNewLine();
        this.m_line.append("</example>");
        this.outputLine();
    }

    private void writePriority(int priority) {
        this.setupNewLine();
        this.m_line.append("<priority>");
        this.outputLine();
        this.indent();
        this.setupNewLine();
        this.m_line.append(String.valueOf(priority));
        this.outputLine();
        this.outdent();
        this.setupNewLine();
        this.m_line.append("</priority>");
        this.outputLine();
    }

    private void writeProperties(Rule rule) {
        this.setupNewLine();
        this.m_line.append("<properties>");
        this.outputLine();
        this.indent();
        RuleProperties properties = rule.getProperties();
        Enumeration keys = properties.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            String value = properties.getValue(name);
            String valueType = properties.getValueType(name);
            this.setupNewLine();
            this.m_line.append("<property name=\"");
            this.m_line.append(name);
            this.m_line.append("\" value=\"");
            this.m_line.append(value);
            this.m_line.append("\" type=\"");
            this.m_line.append(valueType);
            this.m_line.append("\"/>");
            this.outputLine();
        }
        this.outdent();
        this.setupNewLine();
        this.m_line.append("</properties>");
        this.outputLine();
    }

    private void indent() {
        this.m_indent += 3;
    }

    private void outdent() {
        this.m_indent -= 3;
    }

    private void setupNewLine() {
        this.m_line.setLength(0);
        int n = 0;
        while (n < this.m_indent) {
            this.m_line.append(' ');
            ++n;
        }
    }

    private void setupNewLineWithoutIndent() {
        this.m_line.setLength(0);
    }

    private void outputLine() {
        this.m_outputStream.println(this.m_line.toString());
    }
}

