/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.MarkComparator;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.TokenEntry;

public class MatchCollector {
    private List marks;
    private List code;
    private MarkComparator mc;

    public MatchCollector(List marks, List code, MarkComparator mc) {
        this.marks = marks;
        this.code = code;
        this.mc = mc;
    }

    public List collect(int min) {
        ArrayList<Match> matches = new ArrayList<Match>();
        HashSet<String> soFar = new HashSet<String>();
        int i = 1;
        while (i < this.marks.size()) {
            int matchedTokens = 0;
            Mark mark1 = (Mark)this.marks.get(i);
            Mark mark2 = (Mark)this.marks.get(i - 1);
            int j = 0;
            while (j < this.code.size()) {
                TokenEntry token2;
                TokenEntry token1 = this.mc.tokenAt(j, mark1);
                if (!token1.equals(token2 = this.mc.tokenAt(j, mark2)) || token1 == TokenEntry.EOF || token2 == TokenEntry.EOF) break;
                ++matchedTokens;
                ++j;
            }
            if (matchedTokens > min && !soFar.contains(mark1.getTokenSrcID()) && !soFar.contains(mark2.getTokenSrcID())) {
                soFar.add(mark1.getTokenSrcID());
                soFar.add(mark2.getTokenSrcID());
                matches.add(new Match(matchedTokens, mark1, mark2));
            }
            ++i;
        }
        return matches;
    }
}

