/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import net.sourceforge.pmd.PMDException;

class Preferences {
    private Properties m_properties = new Properties();
    private String m_defaultUserPathToPMD = System.getProperty("user.home");
    private String m_defaultSharedPathToPMD;
    private String m_defaultCurrentPathToPMD;
    private String m_defaultAnalysisResultsPath;
    private String m_preferencesPath;
    private static Preferences m_preferences;
    private final String USER_PATH_TO_PMD = "user_path_to_pmd";
    private final String SHARED_PATH_TO_PMD = "shared_path_to_pmd";
    private final String CURRENT_PATH_TO_PMD = "current_path_to_pmd";
    private final String LOWEST_PRIORITY_FOR_ANALYSIS = "lowest_priority_for_analysis";
    private final String ANALYSIS_RESULTS_PATH = "analysis_results_path";
    private final String UNIVERSAL_SEPARATOR = "&US;";
    private final String PREFERENCES_FILE_NAME = "user.preferences";
    private final String PMD_DIRECTORY = "pmd";
    private final String ANALYSIS_RESULTS_DIRECTORY = "Analysis_Results";
    private final int LOWEST_RULE_PRIORITY = 5;

    private Preferences() throws PMDException {
        this.setPath("user_path_to_pmd", this.m_defaultUserPathToPMD);
        this.m_defaultCurrentPathToPMD = this.m_defaultUserPathToPMD;
        this.setPath("current_path_to_pmd", this.m_defaultCurrentPathToPMD);
        this.m_defaultSharedPathToPMD = System.getProperty("user.dir");
        this.setPath("shared_path_to_pmd", this.m_defaultSharedPathToPMD);
        this.m_defaultAnalysisResultsPath = this.m_defaultUserPathToPMD + File.separator + "pmd" + File.separator + "Analysis_Results";
        this.setPath("analysis_results_path", this.m_defaultAnalysisResultsPath);
        this.getPreferencesPath();
    }

    protected static final Preferences getPreferences() throws PMDException {
        if (m_preferences == null) {
            m_preferences = new Preferences();
            m_preferences.load();
        }
        return m_preferences;
    }

    protected void getPreferencesPath() throws PMDException {
        this.m_preferencesPath = System.getProperty("user.home") + File.separator + "pmd" + File.separator + "user.preferences";
        File file = new File(this.m_preferencesPath);
        if (!file.exists()) {
            File directory = file.getParentFile();
            try {
                directory.mkdirs();
                file.createNewFile();
            }
            catch (IOException exception) {
                String template = "Could not create file \"{0}\" in your home directory \"{1}\".";
                Object[] args = new Object[]{"user.preferences", directory};
                String message = MessageFormat.format(template, args);
                PMDException pmdException = new PMDException(message, exception);
                pmdException.fillInStackTrace();
                throw pmdException;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean load() throws PMDException {
        boolean bl;
        File file = new File(this.m_preferencesPath);
        FileInputStream inputStream = null;
        try {
            try {
                inputStream = new FileInputStream(file);
                this.m_properties.load(inputStream);
                if (!this.m_properties.containsKey("user_path_to_pmd")) {
                    this.m_properties.setProperty("user_path_to_pmd", this.m_defaultUserPathToPMD);
                }
                if (!this.m_properties.containsKey("shared_path_to_pmd")) {
                    this.m_properties.setProperty("shared_path_to_pmd", this.m_defaultSharedPathToPMD);
                }
                if (!this.m_properties.containsKey("current_path_to_pmd")) {
                    this.m_properties.setProperty("current_path_to_pmd", this.m_defaultCurrentPathToPMD);
                }
                if (!this.m_properties.containsKey("analysis_results_path")) {
                    this.m_properties.setProperty("analysis_results_path", this.m_defaultAnalysisResultsPath);
                }
                bl = true;
                Object var10_5 = null;
                if (inputStream == null) return bl;
            }
            catch (FileNotFoundException exception) {
                String template = "Could not find file \"{0}\" in directory \"{1}\".";
                Object[] args = new Object[]{"user.preferences", this.m_preferencesPath};
                String message = MessageFormat.format(template, args);
                PMDException pmdException = new PMDException(message, exception);
                pmdException.fillInStackTrace();
                throw pmdException;
            }
            catch (IOException exception) {
                String template = "Could not load file \"{0}\" from directory \"{1}\".";
                Object[] args = new Object[]{"user.preferences", this.m_preferencesPath};
                String message = MessageFormat.format(template, args);
                PMDException pmdException = new PMDException(message, exception);
                pmdException.fillInStackTrace();
                throw pmdException;
            }
        }
        catch (Throwable throwable) {
            Object var10_6 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException exception) {
                exception.printStackTrace();
                throw throwable;
            }
        }
        try {}
        catch (IOException exception) {
            exception.printStackTrace();
            return bl;
        }
        inputStream.close();
        return bl;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void save() throws PMDException {
        FileOutputStream outputStream = null;
        File file = new File(this.m_preferencesPath);
        if (!file.exists()) {
            file.createNewFile();
        }
        outputStream = new FileOutputStream(this.m_preferencesPath);
        this.m_properties.store(outputStream, null);
        Object var9_4 = null;
        if (outputStream == null) return;
        try {
            outputStream.close();
            return;
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return;
        {
            catch (FileNotFoundException exception) {
                String template = "Could not find your \"{0}\" file in your home directory \"{1}\".";
                Object[] args = new Object[]{"user.preferences", this.m_preferencesPath};
                String message = MessageFormat.format(template, args);
                PMDException pmdException = new PMDException(message, exception);
                pmdException.fillInStackTrace();
                throw pmdException;
            }
            catch (IOException exception) {
                String template = "Could not save your \"{0}\" file in your home directory \"{1}\".";
                Object[] args = new Object[]{"user.preferences", this.m_preferencesPath};
                String message = MessageFormat.format(template, args);
                PMDException pmdException = new PMDException(message, exception);
                pmdException.fillInStackTrace();
                throw pmdException;
            }
        }
        catch (Throwable throwable) {
            Object var9_5 = null;
            if (outputStream == null) throw throwable;
            try {
                outputStream.close();
                throw throwable;
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
            throw throwable;
        }
    }

    protected void setCurrentPathToPMD(String path) {
        this.setPath("current_path_to_pmd", path);
    }

    protected void setUserPathToPMD(String path) {
        this.setPath("user_path_to_pmd", path);
    }

    protected void setSharedPathToPMD(String path) {
        this.setPath("shared_path_to_pmd", path);
    }

    private boolean setPath(String name, String directory) {
        name = this.trim(name);
        directory = this.trim(directory);
        if (name.length() == 0 || directory.length() == 0) {
            return false;
        }
        String key = name.toLowerCase();
        directory = this.encodePath(directory);
        this.m_properties.put(key, directory);
        return true;
    }

    protected void setAnalysisResultPath(String directory) {
        directory = this.encodePath(this.trim(directory));
        this.m_properties.put("analysis_results_path", directory);
    }

    protected void setLowestPriorityForAnalysis(int priority) {
        if (priority < 0) {
            priority = 0;
        } else if (priority > 5) {
            priority = 5;
        }
        this.m_properties.put("lowest_priority_for_analysis", String.valueOf(priority));
    }

    protected int getLowestPriorityForAnalysis() {
        int priority;
        try {
            priority = Integer.parseInt((String)this.m_properties.get("lowest_priority_for_analysis"));
        }
        catch (NumberFormatException exception) {
            priority = 5;
        }
        return priority;
    }

    private String encodePath(String directory) {
        if (directory != null) {
            StringBuffer buffer = new StringBuffer(directory.length() + 50);
            buffer.append(directory);
            int n = 0;
            while (n < buffer.length()) {
                if (buffer.charAt(n) == File.separatorChar) {
                    buffer.replace(n, n + 1, "&US;");
                }
                ++n;
            }
            directory = buffer.toString();
        }
        return directory;
    }

    private String decodePath(String value) {
        if (value != null) {
            StringBuffer buffer = new StringBuffer(value);
            int universalSeparatorLength = "&US;".length();
            int n = 0;
            while (n < buffer.length()) {
                if (buffer.charAt(n) == '&' && n + universalSeparatorLength <= buffer.length() && buffer.charAt(n + 1) == 'U' && buffer.charAt(n + 2) == 'S' && buffer.charAt(n + 3) == ';') {
                    buffer.replace(n, n + universalSeparatorLength, File.separator);
                }
                ++n;
            }
            value = buffer.toString();
        }
        return value;
    }

    protected String getAnalysisResultsPath() {
        String path = this.decodePath(this.m_properties.getProperty("analysis_results_path"));
        if (path == null) {
            path = this.m_defaultAnalysisResultsPath;
        }
        new File(path).mkdirs();
        return path;
    }

    private String getPathToPMD(String pathName) {
        String key = this.trim(pathName).toLowerCase();
        String directory = this.decodePath(this.m_properties.getProperty(key));
        if (directory == null) {
            directory = "";
        }
        return directory;
    }

    protected String getCurrentPathToPMD() {
        return this.getPathToPMD("current_path_to_pmd");
    }

    protected String getUserPathToPMD() {
        return this.getPathToPMD("user_path_to_pmd");
    }

    protected String getSharedPathToPMD() {
        return this.getPathToPMD("shared_path_to_pmd");
    }

    private String trim(String text) {
        if (text == null) {
            text = "";
        } else if ((text = text.trim()).length() == 0) {
            text = "";
        }
        return text;
    }
}

