/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.swingui.ComponentFactory;
import net.sourceforge.pmd.swingui.MessageDialog;
import net.sourceforge.pmd.swingui.RulesTreeNode;
import net.sourceforge.pmd.swingui.event.ListenerList;
import net.sourceforge.pmd.swingui.event.RulesEditingEvent;
import net.sourceforge.pmd.swingui.event.RulesEditingEventListener;

class RuleEditingPanel
extends JPanel {
    private JLabel m_nameLabel;
    private JTextField m_name;
    private JLabel m_classNameLabel;
    private JTextField m_className;
    private JLabel m_messageLabel;
    private JTextArea m_message;
    private JScrollPane m_messageScrollPane;
    private JLabel m_descriptionLabel;
    private JTextArea m_description;
    private JScrollPane m_descriptionScrollPane;
    private JLabel m_exampleLabel;
    private JTextArea m_example;
    private JScrollPane m_exampleScrollPane;
    private JLabel m_priorityLabel;
    private JComboBox m_priority;
    private boolean m_enabled;
    private RulesTreeNode m_currentDataNode;
    private boolean m_isEditing;
    private String m_originalName;
    private FocusListener m_focusListener = new RuleNameFocusListener();

    protected RuleEditingPanel() {
        super(new BorderLayout());
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        this.setBorder(emptyBorder);
        int[] columnWidths = new int[]{50, 100, 100, 100, 100, 100};
        GridBagLayout layout = new GridBagLayout();
        layout.columnWidths = columnWidths;
        JPanel panel = new JPanel(layout);
        TitledBorder titledBorder = ComponentFactory.createTitledBorder("  Rule  ");
        panel.setBorder(titledBorder);
        this.add((Component)panel, "Center");
        Font labelFont = UIManager.getFont("labelFont");
        this.m_nameLabel = new JLabel("Name");
        this.m_nameLabel.setFont(labelFont);
        this.m_nameLabel.setHorizontalAlignment(4);
        GridBagConstraints constraints = layout.getConstraints(this.m_nameLabel);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 12;
        constraints.fill = 0;
        constraints.insets = new Insets(4, 2, 4, 2);
        panel.add((Component)this.m_nameLabel, constraints);
        this.m_name = new JTextField();
        this.m_name.setFont(UIManager.getFont("dataFont"));
        this.m_name.addFocusListener(this.m_focusListener);
        this.m_name.setRequestFocusEnabled(true);
        this.m_name.setOpaque(true);
        constraints = layout.getConstraints(this.m_name);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(4, 2, 4, 2);
        panel.add((Component)this.m_name, constraints);
        this.m_classNameLabel = new JLabel("Class Name");
        this.m_classNameLabel.setFont(labelFont);
        this.m_classNameLabel.setHorizontalAlignment(4);
        constraints = layout.getConstraints(this.m_name);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 12;
        constraints.fill = 0;
        constraints.insets = new Insets(4, 2, 4, 2);
        panel.add((Component)this.m_classNameLabel, constraints);
        this.m_className = new JTextField();
        this.m_className.setFont(UIManager.getFont("dataFont"));
        this.m_className.setBackground(UIManager.getColor("disabledTextBackground"));
        this.m_className.setForeground(Color.black);
        this.m_className.setSelectedTextColor(Color.black);
        this.m_className.setDisabledTextColor(Color.black);
        this.m_className.setEditable(false);
        this.m_className.setEnabled(false);
        this.m_className.setOpaque(true);
        constraints = layout.getConstraints(this.m_name);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.gridheight = 1;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(4, 2, 4, 2);
        panel.add((Component)this.m_className, constraints);
        this.m_messageLabel = new JLabel("Message");
        this.m_messageLabel.setFont(labelFont);
        this.m_messageLabel.setHorizontalAlignment(4);
        constraints = layout.getConstraints(this.m_name);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 12;
        constraints.fill = 0;
        constraints.insets = new Insets(4, 2, 4, 2);
        panel.add((Component)this.m_messageLabel, constraints);
        this.m_message = ComponentFactory.createTextArea("");
        this.m_messageScrollPane = ComponentFactory.createScrollPane(this.m_message);
        constraints = layout.getConstraints(this.m_name);
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 0;
        constraints.gridheight = 1;
        constraints.ipady = 80;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(4, 2, 4, 2);
        panel.add((Component)this.m_messageScrollPane, constraints);
        this.m_descriptionLabel = new JLabel("Description");
        this.m_descriptionLabel.setFont(labelFont);
        this.m_descriptionLabel.setHorizontalAlignment(4);
        constraints = layout.getConstraints(this.m_name);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 12;
        constraints.fill = 0;
        constraints.insets = new Insets(4, 2, 4, 2);
        panel.add((Component)this.m_descriptionLabel, constraints);
        this.m_description = ComponentFactory.createTextArea("");
        this.m_descriptionScrollPane = ComponentFactory.createScrollPane(this.m_description);
        constraints = layout.getConstraints(this.m_name);
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.gridheight = 1;
        constraints.ipady = 80;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(4, 2, 4, 2);
        panel.add((Component)this.m_descriptionScrollPane, constraints);
        this.m_exampleLabel = new JLabel("Example");
        this.m_exampleLabel.setFont(labelFont);
        this.m_exampleLabel.setHorizontalAlignment(4);
        constraints = layout.getConstraints(this.m_name);
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 12;
        constraints.fill = 0;
        constraints.insets = new Insets(4, 2, 4, 2);
        panel.add((Component)this.m_exampleLabel, constraints);
        this.m_example = ComponentFactory.createTextArea("");
        this.m_example.setFont(UIManager.getFont("codeFont"));
        this.m_exampleScrollPane = ComponentFactory.createScrollPane(this.m_example);
        constraints = layout.getConstraints(this.m_name);
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.gridwidth = 0;
        constraints.gridheight = 1;
        constraints.ipady = 120;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(4, 2, 4, 2);
        panel.add((Component)this.m_exampleScrollPane, constraints);
        this.m_priorityLabel = new JLabel("Priority");
        this.m_priorityLabel.setFont(labelFont);
        this.m_priorityLabel.setHorizontalAlignment(4);
        constraints = layout.getConstraints(this.m_name);
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 12;
        constraints.fill = 0;
        constraints.insets = new Insets(4, 2, 4, 2);
        panel.add((Component)this.m_priorityLabel, constraints);
        this.m_priority = new JComboBox<String>(Rule.PRIORITIES);
        constraints = layout.getConstraints(this.m_name);
        constraints.gridx = 1;
        constraints.gridy = 5;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(4, 2, 4, 2);
        panel.add((Component)this.m_priority, constraints);
        this.enableData(false);
        ListenerList.addListener(new RulesEditingEventHandler());
    }

    private void saveData(RulesTreeNode dataNode) {
        if (dataNode != null && this.m_isEditing && (dataNode.isRule() || dataNode.isProperty())) {
            String ruleName = this.m_name.getText().trim();
            if (ruleName.length() == 0) {
                String message = "The rule name is missing.  The change will not be applied.";
                this.m_name.removeFocusListener(this.m_focusListener);
                MessageDialog.show(this.getParentWindow(), message);
                this.m_name.addFocusListener(this.m_focusListener);
                if (this.m_name.hasFocus()) {
                    this.m_name.requestFocus();
                }
                ruleName = this.m_originalName;
            } else if (!ruleName.equalsIgnoreCase(this.m_originalName) && dataNode.getSibling(ruleName) != null) {
                String template = "Another rule already has the name \"{0}\".  The change will not be applied.";
                Object[] args = new String[]{ruleName};
                String message = MessageFormat.format(template, args);
                this.m_name.removeFocusListener(this.m_focusListener);
                MessageDialog.show(this.getParentWindow(), message);
                this.m_name.addFocusListener(this.m_focusListener);
                if (this.m_name.hasFocus()) {
                    this.m_name.requestFocus();
                }
                ruleName = this.m_originalName;
            }
            dataNode.setName(ruleName);
            dataNode.setClassName(this.m_className.getText());
            dataNode.setMessage(this.m_message.getText());
            dataNode.setDescription(this.m_description.getText());
            dataNode.setExample(this.m_example.getText());
            dataNode.setPriority(this.m_priority.getSelectedIndex() + 1);
        }
    }

    protected void setIsEditing(boolean isEditing) {
        this.m_isEditing = isEditing;
    }

    private void loadData(RulesTreeNode dataNode) {
        if (dataNode == null) {
            this.enableData(false);
        } else if (dataNode.isRuleSet()) {
            this.enableData(false);
        } else if (dataNode.isRule()) {
            this.loadData_(dataNode);
        } else if (dataNode.isProperty()) {
            this.loadData_(dataNode.getParentRuleData());
        } else {
            this.enableData(false);
        }
    }

    private void loadData_(RulesTreeNode dataNode) {
        if (!this.m_enabled) {
            this.enableData(true);
        }
        this.m_name.setText(dataNode.getName());
        this.m_className.setText(dataNode.getClassName());
        this.m_message.setText(dataNode.getMessage());
        this.m_description.setText(dataNode.getDescription());
        this.m_example.setText(dataNode.getExample());
        this.m_priority.setSelectedIndex(dataNode.getPriority() - 1);
        this.m_originalName = dataNode.getName();
        this.m_currentDataNode = dataNode;
    }

    private void enableData(boolean enable) {
        if (enable) {
            this.m_name.removeFocusListener(this.m_focusListener);
            this.m_name.addFocusListener(this.m_focusListener);
            this.m_nameLabel.setEnabled(true);
            this.m_name.setEnabled(true);
            this.m_name.setBackground(Color.white);
            this.m_messageLabel.setEnabled(true);
            this.m_message.setEnabled(true);
            this.m_message.setBackground(Color.white);
            this.m_classNameLabel.setEnabled(true);
            this.m_descriptionLabel.setEnabled(true);
            this.m_description.setEnabled(true);
            this.m_description.setBackground(Color.white);
            this.m_exampleLabel.setEnabled(true);
            this.m_example.setEnabled(true);
            this.m_example.setBackground(Color.white);
            this.m_priorityLabel.setEnabled(true);
            this.m_priority.setEnabled(true);
            this.m_priority.setBackground(Color.white);
        } else {
            this.m_name.removeFocusListener(this.m_focusListener);
            Color background = UIManager.getColor("disabledTextBackground");
            this.m_nameLabel.setEnabled(false);
            this.m_name.setText("");
            this.m_name.setEnabled(false);
            this.m_name.setBackground(background);
            this.m_messageLabel.setEnabled(false);
            this.m_message.setText("");
            this.m_message.setEnabled(false);
            this.m_message.setBackground(background);
            this.m_classNameLabel.setEnabled(false);
            this.m_className.setText("");
            this.m_descriptionLabel.setEnabled(false);
            this.m_description.setText("");
            this.m_description.setEnabled(false);
            this.m_description.setBackground(background);
            this.m_exampleLabel.setEnabled(false);
            this.m_example.setText("");
            this.m_example.setEnabled(false);
            this.m_example.setBackground(background);
            this.m_priorityLabel.setEnabled(false);
            this.m_priority.setSelectedIndex(0);
            this.m_priority.setEnabled(false);
            this.m_priority.setBackground(background);
            this.m_currentDataNode = null;
        }
        this.m_enabled = enable;
    }

    private Window getParentWindow() {
        Container component = this.getParent();
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        return (Window)component;
    }

    private class RulesEditingEventHandler
    implements RulesEditingEventListener {
        private RulesEditingEventHandler() {
        }

        public void loadData(RulesEditingEvent event) {
            RuleEditingPanel.this.loadData(event.getDataNode());
        }

        public void saveData(RulesEditingEvent event) {
            RuleEditingPanel.this.saveData(event.getDataNode());
        }
    }

    private class RuleNameFocusListener
    implements FocusListener {
        private RuleNameFocusListener() {
        }

        public void focusGained(FocusEvent event) {
        }

        public void focusLost(FocusEvent event) {
            String ruleName = RuleEditingPanel.this.m_name.getText().trim();
            if (ruleName.length() == 0) {
                String message = "The rule name is missing.";
                RuleEditingPanel.this.m_name.removeFocusListener(this);
                MessageDialog.show(RuleEditingPanel.this.getParentWindow(), message);
                RuleEditingPanel.this.m_name.addFocusListener(this);
                RuleEditingPanel.this.m_name.requestFocus();
            } else if (!ruleName.equalsIgnoreCase(RuleEditingPanel.this.m_originalName) && RuleEditingPanel.this.m_currentDataNode.getSibling(ruleName) != null) {
                String template = "Another rule already has the name \"{0}\".";
                Object[] args = new String[]{ruleName};
                String message = MessageFormat.format(template, args);
                RuleEditingPanel.this.m_name.removeFocusListener(this);
                MessageDialog.show(RuleEditingPanel.this.getParentWindow(), message);
                RuleEditingPanel.this.m_name.addFocusListener(this);
                RuleEditingPanel.this.m_name.requestFocus();
            }
        }
    }
}

