/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleProperties;
import net.sourceforge.pmd.RuleViolation;

public class MockRule
implements Rule {
    private String name;
    private String description;
    private String message;
    private Set violations = new HashSet();
    private RuleProperties properties = new RuleProperties();
    private String example;
    private boolean m_include;
    private int priority;

    public String getExample() {
        return this.example;
    }

    public void setExample(String example) {
        this.example = example;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getPriorityName() {
        return null;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public void addProperty(String name, String value) {
        this.properties.setValue(name, value);
    }

    public int getIntProperty(String name) {
        return Integer.parseInt(this.properties.getProperty(name));
    }

    public double getDoubleProperty(String name) {
        return Double.parseDouble(this.properties.getProperty(name));
    }

    public boolean getBooleanProperty(String name) {
        return Boolean.valueOf(this.properties.getProperty(name));
    }

    public String getStringProperty(String name) {
        return this.properties.getProperty(name);
    }

    public RuleProperties getProperties() {
        return this.properties;
    }

    public boolean include() {
        return true;
    }

    public void setInclude(boolean include) {
        this.m_include = include;
    }

    public MockRule() {
    }

    public MockRule(String name, String description, String message) {
        this.name = name;
        this.description = description;
        this.message = message;
    }

    public void addViolation(RuleViolation violation) {
        this.violations.add(violation);
    }

    public void apply(List astCompilationUnits, RuleContext ctx) {
        Report report = ctx.getReport();
        Iterator vs = this.violations.iterator();
        while (vs.hasNext()) {
            report.addRuleViolation((RuleViolation)vs.next());
        }
    }
}

