/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import edu.uci.ics.jung.algorithms.MatrixElementOperations;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.ConstantEdgeValue;
import edu.uci.ics.jung.graph.decorators.Indexer;
import edu.uci.ics.jung.graph.decorators.NumberEdgeValue;
import edu.uci.ics.jung.graph.decorators.UserDatumNumberEdgeValue;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.graph.impl.SparseGraph;
import edu.uci.ics.jung.graph.impl.UndirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.UndirectedSparseGraph;
import edu.uci.ics.jung.utils.GraphUtils;
import edu.uci.ics.jung.utils.UserData;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class GraphMatrixOperations {
    public static Graph square(Graph g, MatrixElementOperations meo) {
        Vertex v;
        Graph G2 = (Graph)g.newInstance();
        Set V = g.getVertices();
        Iterator it = V.iterator();
        while (it.hasNext()) {
            v = (Vertex)it.next();
            v.copy(G2);
        }
        Iterator vertices = V.iterator();
        while (vertices.hasNext()) {
            v = (Vertex)vertices.next();
            Iterator preds = v.getPredecessors().iterator();
            while (preds.hasNext()) {
                Vertex src = (Vertex)preds.next();
                Vertex d2_src = (Vertex)src.getEqualVertex(G2);
                Edge e1 = src.findEdge(v);
                Iterator succs = v.getSuccessors().iterator();
                while (succs.hasNext()) {
                    Vertex dest = (Vertex)succs.next();
                    Vertex d2_dest = (Vertex)dest.getEqualVertex(G2);
                    Edge e2 = v.findEdge(dest);
                    Object pathData = meo.computePathData(e1, e2);
                    Edge e = d2_src.findEdge(d2_dest);
                    if (e == null) {
                        e = GraphUtils.addEdge(G2, d2_src, d2_dest);
                    }
                    meo.mergePaths(e, pathData);
                }
            }
        }
        return G2;
    }

    public static Graph matrixToGraph(DoubleMatrix2D matrix, NumberEdgeValue nev) {
        if (matrix.rows() != matrix.columns()) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        int size = matrix.rows();
        boolean isSymmetric = true;
        block0: for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                if (matrix.getQuick(i, j) == matrix.getQuick(j, i)) continue;
                isSymmetric = false;
                break block0;
            }
        }
        SparseGraph graph = isSymmetric ? new UndirectedSparseGraph() : new DirectedSparseGraph();
        GraphUtils.addVertices((Graph)graph, size);
        Indexer id = Indexer.getIndexer(graph);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                double value = matrix.getQuick(i, j);
                if (value == 0.0) continue;
                Vertex vI = (Vertex)id.getVertex(i);
                Vertex vJ = (Vertex)id.getVertex(j);
                Edge e = null;
                if (isSymmetric) {
                    if (i <= j) {
                        e = graph.addEdge(new UndirectedSparseEdge(vI, vJ));
                    }
                } else {
                    e = graph.addEdge(new DirectedSparseEdge(vI, vJ));
                }
                if (e == null || nev == null) continue;
                nev.setNumber(e, new Double(value));
            }
        }
        return graph;
    }

    public static Graph matrixToGraph(DoubleMatrix2D matrix, String weightKey) {
        if (weightKey == null) {
            return GraphMatrixOperations.matrixToGraph(matrix, (NumberEdgeValue)null);
        }
        UserDatumNumberEdgeValue nev = new UserDatumNumberEdgeValue(weightKey);
        nev.setCopyAction(UserData.SHARED);
        return GraphMatrixOperations.matrixToGraph(matrix, nev);
    }

    public static Graph matrixToGraph(DoubleMatrix2D matrix) {
        return GraphMatrixOperations.matrixToGraph(matrix, (NumberEdgeValue)null);
    }

    public static SparseDoubleMatrix2D graphToSparseMatrix(Graph g, Object edgeWeightKey) {
        if (edgeWeightKey == null) {
            return GraphMatrixOperations.graphToSparseMatrix(g);
        }
        return GraphMatrixOperations.graphToSparseMatrix(g, new UserDatumNumberEdgeValue(edgeWeightKey));
    }

    public static SparseDoubleMatrix2D graphToSparseMatrix(Graph g) {
        return GraphMatrixOperations.graphToSparseMatrix(g, new ConstantEdgeValue(1.0));
    }

    public static SparseDoubleMatrix2D graphToSparseMatrix(Graph g, NumberEdgeValue nev) {
        if (nev == null) {
            nev = new ConstantEdgeValue(1.0);
        }
        int numVertices = g.getVertices().size();
        SparseDoubleMatrix2D matrix = new SparseDoubleMatrix2D(numVertices, numVertices);
        Indexer id = Indexer.getIndexer(g);
        for (int i = 0; i < numVertices; ++i) {
            Vertex v = (Vertex)id.getVertex(i);
            Iterator o_iter = v.getOutEdges().iterator();
            while (o_iter.hasNext()) {
                Edge e = (Edge)o_iter.next();
                Vertex w = e.getOpposite(v);
                int j = id.getIndex(w);
                matrix.set(i, j, matrix.getQuick(i, j) + nev.getNumber(e).doubleValue());
            }
        }
        return matrix;
    }

    public static SparseDoubleMatrix2D createVertexDegreeDiagonalMatrix(Graph G) {
        int numVertices = G.getVertices().size();
        SparseDoubleMatrix2D matrix = new SparseDoubleMatrix2D(numVertices, numVertices);
        Indexer id = Indexer.getIndexer(G);
        Iterator v_iter = G.getVertices().iterator();
        while (v_iter.hasNext()) {
            Vertex v = (Vertex)v_iter.next();
            matrix.set(id.getIndex(v), id.getIndex(v), (double)v.degree());
        }
        return matrix;
    }

    public static DoubleMatrix2D computeVoltagePotentialMatrix(UndirectedGraph graph) {
        int numVertices = graph.numVertices();
        SparseDoubleMatrix2D A = GraphMatrixOperations.graphToSparseMatrix((Graph)graph, null);
        SparseDoubleMatrix2D D = GraphMatrixOperations.createVertexDegreeDiagonalMatrix(graph);
        SparseDoubleMatrix2D temp = new SparseDoubleMatrix2D(numVertices - 1, numVertices - 1);
        for (int i = 0; i < numVertices - 1; ++i) {
            for (int j = 0; j < numVertices - 1; ++j) {
                temp.set(i, j, D.get(i, j) - A.get(i, j));
            }
        }
        Algebra algebra = new Algebra();
        DoubleMatrix2D tempInverse = algebra.inverse((DoubleMatrix2D)temp);
        SparseDoubleMatrix2D T = new SparseDoubleMatrix2D(numVertices, numVertices);
        for (int i = 0; i < numVertices - 1; ++i) {
            for (int j = 0; j < numVertices - 1; ++j) {
                T.set(i, j, tempInverse.get(i, j));
            }
        }
        return T;
    }

    public static DoubleMatrix1D mapTo1DMatrix(Map M) {
        int numVertices = M.size();
        DenseDoubleMatrix1D vector = new DenseDoubleMatrix1D(numVertices);
        Set vertices = M.keySet();
        Indexer id = Indexer.getIndexer(((Vertex)vertices.iterator().next()).getGraph());
        Iterator v_iter = vertices.iterator();
        while (v_iter.hasNext()) {
            Vertex v = (Vertex)v_iter.next();
            int v_id = id.getIndex(v);
            if (v_id < 0 || v_id > numVertices) {
                throw new IllegalArgumentException("Vertex ID not supported by mapTo1DMatrix: outside range [0,n-1]");
            }
            vector.set(v_id, ((Double)M.get(v)).doubleValue());
        }
        return vector;
    }

    public static DoubleMatrix2D computeMeanFirstPassageMatrix(Graph G, Object edgeWeightKey, DoubleMatrix1D stationaryDistribution) {
        SparseDoubleMatrix2D temp = GraphMatrixOperations.graphToSparseMatrix(G, edgeWeightKey);
        for (int i = 0; i < temp.rows(); ++i) {
            for (int j = 0; j < temp.columns(); ++j) {
                double value = -1.0 * temp.get(i, j) + stationaryDistribution.get(j);
                if (i == j) {
                    value += 1.0;
                }
                if (value == 0.0) continue;
                temp.set(i, j, value);
            }
        }
        Algebra algebra = new Algebra();
        DoubleMatrix2D fundamentalMatrix = algebra.inverse((DoubleMatrix2D)temp);
        temp = new SparseDoubleMatrix2D(temp.rows(), temp.columns());
        for (int i = 0; i < temp.rows(); ++i) {
            for (int j = 0; j < temp.columns(); ++j) {
                double value = -1.0 * fundamentalMatrix.get(i, j);
                value += fundamentalMatrix.get(j, j);
                if (i == j) {
                    value += 1.0;
                }
                if (value == 0.0) continue;
                temp.set(i, j, value);
            }
        }
        SparseDoubleMatrix2D stationaryMatrixDiagonal = new SparseDoubleMatrix2D(temp.rows(), temp.columns());
        int numVertices = stationaryDistribution.size();
        for (int i = 0; i < numVertices; ++i) {
            stationaryMatrixDiagonal.set(i, i, 1.0 / stationaryDistribution.get(i));
        }
        DoubleMatrix2D meanFirstPassageMatrix = algebra.mult((DoubleMatrix2D)temp, (DoubleMatrix2D)stationaryMatrixDiagonal);
        return meanFirstPassageMatrix;
    }
}

