/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.cluster;

import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.Element;
import edu.uci.ics.jung.graph.Graph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ClusterSet {
    private List mClusters = new ArrayList();
    private Map mUDCToClustersMap = new HashMap();
    private ArchetypeGraph mUnderlyingGraph;

    public ClusterSet(ArchetypeGraph underlyingGraph) {
        this.mUnderlyingGraph = underlyingGraph;
    }

    public void addCluster(Set elements) {
        if (elements == null || elements.size() == 0) {
            throw new IllegalArgumentException("The set of elements must have at least one element");
        }
        Iterator udcIt = elements.iterator();
        while (udcIt.hasNext()) {
            Element udc = (Element)udcIt.next();
            this.checkLegality(udc);
            HashSet<Set> components = (HashSet<Set>)this.mUDCToClustersMap.get(udc);
            if (components == null) {
                components = new HashSet<Set>();
                this.mUDCToClustersMap.put(udc, components);
            }
            components.add(elements);
        }
        this.mClusters.add(elements);
    }

    protected void checkLegality(Element e) {
        if (e.getGraph() != this.getUnderlyingGraph()) {
            throw new IllegalArgumentException("All elements passed in must be from the correct underlying graph.");
        }
    }

    public abstract Graph getClusterAsNewSubGraph(int var1);

    public abstract ClusterSet createEquivalentClusterSet(Graph var1);

    public Set getClusters(Element element) {
        return (Set)this.mUDCToClustersMap.get(element);
    }

    public Set getCluster(int index) {
        return (Set)this.mClusters.get(index);
    }

    public Iterator iterator() {
        return this.mClusters.iterator();
    }

    public int size() {
        return this.mClusters.size();
    }

    public void sort() {
        Collections.sort(this.mClusters, new Comparator(){

            public int compare(Object o1, Object o2) {
                Set cluster1 = (Set)o1;
                Set cluster2 = (Set)o2;
                if (cluster1.size() < cluster2.size()) {
                    return 1;
                }
                if (cluster1.size() > cluster2.size()) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public ArchetypeGraph getUnderlyingGraph() {
        return this.mUnderlyingGraph;
    }
}

