/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.cluster;

import cern.jet.random.engine.DRand;
import cern.jet.random.engine.RandomEngine;
import edu.uci.ics.jung.statistics.DiscreteDistribution;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class KMeansClusterer {
    protected int max_iterations;
    protected double convergence_threshold;
    protected RandomEngine rand = new DRand();

    public KMeansClusterer(int max_iterations, double convergence_threshold) {
        if (max_iterations < 0) {
            throw new IllegalArgumentException("max iterations must be >= 0");
        }
        if (convergence_threshold <= 0.0) {
            throw new IllegalArgumentException("convergence threshold must be > 0");
        }
        this.max_iterations = max_iterations;
        this.convergence_threshold = convergence_threshold;
    }

    public Collection cluster(Map object_locations, int num_clusters) {
        if (num_clusters < 2 || num_clusters > object_locations.size()) {
            throw new IllegalArgumentException("number of clusters must be >= 2 and <= number of objects (" + object_locations.size() + ")");
        }
        if (object_locations == null || object_locations.isEmpty()) {
            throw new IllegalArgumentException("'objects' must be non-empty");
        }
        HashSet<double[]> centroids = new HashSet<double[]>();
        Object[] obj_array = object_locations.keySet().toArray();
        HashSet<Object> tried = new HashSet<Object>();
        while (centroids.size() < num_clusters && tried.size() < object_locations.size()) {
            Object o = obj_array[(int)(this.rand.nextDouble() * (double)obj_array.length)];
            tried.add(o);
            double[] mean_value = (double[])object_locations.get(o);
            boolean duplicate = false;
            Iterator iter = centroids.iterator();
            while (iter.hasNext()) {
                double[] cur = (double[])iter.next();
                if (!Arrays.equals(mean_value, cur)) continue;
                duplicate = true;
            }
            if (duplicate) continue;
            centroids.add(mean_value);
        }
        if (tried.size() >= object_locations.size()) {
            throw new NotEnoughClustersException();
        }
        Map clusterMap = this.assignToClusters(object_locations, centroids);
        int iterations = 0;
        double max_movement = Double.POSITIVE_INFINITY;
        while (iterations++ < this.max_iterations && max_movement > this.convergence_threshold) {
            max_movement = 0.0;
            HashSet<double[]> new_centroids = new HashSet<double[]>();
            Iterator iter = clusterMap.keySet().iterator();
            while (iter.hasNext()) {
                double[] centroid = (double[])iter.next();
                Map elements = (Map)clusterMap.get(centroid);
                double[][] locations = new double[elements.size()][];
                int i = 0;
                Iterator e_iter = elements.keySet().iterator();
                while (e_iter.hasNext()) {
                    locations[i++] = (double[])object_locations.get(e_iter.next());
                }
                double[] mean = DiscreteDistribution.mean(locations);
                max_movement = Math.max(max_movement, Math.sqrt(DiscreteDistribution.squaredError(centroid, mean)));
                new_centroids.add(mean);
            }
            clusterMap = this.assignToClusters(object_locations, new_centroids);
        }
        return clusterMap.values();
    }

    protected Map assignToClusters(Map object_locations, Set centroids) {
        HashMap clusterMap = new HashMap();
        Iterator c_iter = centroids.iterator();
        while (c_iter.hasNext()) {
            clusterMap.put(c_iter.next(), new HashMap());
        }
        Iterator o_iter = object_locations.keySet().iterator();
        while (o_iter.hasNext()) {
            Object o = o_iter.next();
            double[] location = (double[])object_locations.get(o);
            Iterator c_iter2 = centroids.iterator();
            double[] closest = (double[])c_iter2.next();
            double distance = DiscreteDistribution.squaredError(location, closest);
            while (c_iter2.hasNext()) {
                double[] centroid = (double[])c_iter2.next();
                double dist_cur = DiscreteDistribution.squaredError(location, centroid);
                if (!(dist_cur < distance)) continue;
                distance = dist_cur;
                closest = centroid;
            }
            Map elements = (Map)clusterMap.get(closest);
            elements.put(o, location);
        }
        return clusterMap;
    }

    public void setSeed(int random_seed) {
        this.rand = new DRand(random_seed);
    }

    public static class NotEnoughClustersException
    extends RuntimeException {
        public String getMessage() {
            return "Not enough distinct points in the input data set to form the requested number of clusters";
        }
    }
}

