/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.cluster;

import edu.uci.ics.jung.algorithms.cluster.ClusterSet;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.utils.GraphUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class VertexClusterSet
extends ClusterSet {
    public VertexClusterSet(ArchetypeGraph underlyingGraph) {
        super(underlyingGraph);
    }

    public Graph getClusterAsNewSubGraph(int index) {
        return GraphUtils.vertexSetToGraph(this.getCluster(index));
    }

    public ClusterSet createEquivalentClusterSet(Graph anotherGraph) {
        VertexClusterSet newClusterSet = new VertexClusterSet(anotherGraph);
        Iterator cIt = this.iterator();
        while (cIt.hasNext()) {
            Set cluster = (Set)cIt.next();
            HashSet<ArchetypeVertex> newCluster = new HashSet<ArchetypeVertex>();
            Iterator vIt = cluster.iterator();
            while (vIt.hasNext()) {
                ArchetypeVertex vertex = (ArchetypeVertex)vIt.next();
                ArchetypeVertex equivalentVertex = vertex.getEqualVertex(anotherGraph);
                if (equivalentVertex == null) {
                    throw new IllegalArgumentException("Can not create equivalent cluster set because equivalent vertices could not be found in the other graph.");
                }
                newCluster.add(equivalentVertex);
            }
            newClusterSet.addCluster(newCluster);
        }
        return newClusterSet;
    }
}

