/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import edu.uci.ics.jung.algorithms.cluster.ClusterSet;
import edu.uci.ics.jung.algorithms.cluster.WeakComponentClusterer;
import edu.uci.ics.jung.algorithms.importance.RelativeAuthorityRanker;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Element;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.MutableDouble;
import edu.uci.ics.jung.utils.NumericalPrecision;
import edu.uci.ics.jung.utils.UserData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class HITSWithPriors
extends RelativeAuthorityRanker {
    protected static final String AUTHORITY_KEY = "jung.algorithms.importance.AUTHORITY";
    protected static final String HUB_KEY = "jung.algorithms.importance.HUB";
    private static final String IN_EDGE_WEIGHT = "IN_EDGE_WEIGHT";
    private String mKeyToUseForRanking;
    private Map mPreviousAuthorityScores;
    private Map mPreviousHubScores;
    private double mBeta;
    Set mReachableVertices;
    private Set mLeafNodes;

    public HITSWithPriors(Graph graph, double bias, Set priors) {
        this.mKeyToUseForRanking = AUTHORITY_KEY;
        this.mBeta = bias;
        this.setPriors(priors);
        this.initialize(graph, null);
    }

    public HITSWithPriors(Graph graph, boolean useAuthorityForRanking, double bias, Set priors, String edgeWeightKey) {
        this.setUseAuthorityForRanking(useAuthorityForRanking);
        this.mBeta = bias;
        this.setPriors(priors);
        this.initialize(graph, edgeWeightKey);
    }

    protected void initialize(Graph g, String edgeWeightKeyName) {
        super.initialize(g, true, false);
        this.mPreviousAuthorityScores = new HashMap();
        this.mPreviousHubScores = new HashMap();
        Iterator vIt = g.getVertices().iterator();
        while (vIt.hasNext()) {
            Vertex currentVertex = (Vertex)vIt.next();
            this.mPreviousAuthorityScores.put(currentVertex, new MutableDouble(0.0));
            this.mPreviousHubScores.put(currentVertex, new MutableDouble(0.0));
            this.setRankScore(currentVertex, 0.0, AUTHORITY_KEY);
            this.setRankScore(currentVertex, 0.0, HUB_KEY);
            this.setPriorRankScore(currentVertex, 0.0);
        }
        WeakComponentClusterer wcExtractor = new WeakComponentClusterer();
        ClusterSet clusters = wcExtractor.extract(g);
        this.mReachableVertices = new HashSet();
        double numPriors = this.getPriors().size();
        Iterator it = this.getPriors().iterator();
        while (it.hasNext()) {
            Vertex currentVertex = (Vertex)it.next();
            this.setPriorRankScore(currentVertex, 1.0 / numPriors);
            Iterator cIt = clusters.iterator();
            while (cIt.hasNext()) {
                Set members = (Set)cIt.next();
                if (!members.contains(currentVertex)) continue;
                this.mReachableVertices.addAll(members);
            }
        }
        this.mLeafNodes = new HashSet();
        int numReachableVertices = this.mReachableVertices.size();
        Iterator vIt2 = this.mReachableVertices.iterator();
        while (vIt2.hasNext()) {
            Vertex currentVertex = (Vertex)vIt2.next();
            this.setRankScore(currentVertex, 1.0 / (double)numReachableVertices, AUTHORITY_KEY);
            this.setRankScore(currentVertex, 1.0 / (double)numReachableVertices, HUB_KEY);
            if (currentVertex.outDegree() != 0) continue;
            this.mLeafNodes.add(currentVertex);
        }
        if (edgeWeightKeyName == null) {
            this.assignDefaultEdgeTransitionWeights();
        } else {
            this.setUserDefinedEdgeWeightKey(edgeWeightKeyName);
            this.normalizeEdgeTransitionWeights();
        }
        this.assignInlinkEdgeTransitionWeights();
    }

    protected void finalizeIterations() {
        super.finalizeIterations();
        Iterator it = this.getVertices().iterator();
        while (it.hasNext()) {
            Vertex currentVertex = (Vertex)it.next();
            if (this.mKeyToUseForRanking.equals(AUTHORITY_KEY)) {
                currentVertex.removeUserDatum(HUB_KEY);
                continue;
            }
            currentVertex.removeUserDatum(AUTHORITY_KEY);
        }
    }

    protected double getInEdgeWeight(Edge e) {
        MutableDouble value = (MutableDouble)e.getUserDatum(IN_EDGE_WEIGHT);
        return value.doubleValue();
    }

    protected void setInEdgeWeight(Edge e, double weight) {
        MutableDouble value = (MutableDouble)e.getUserDatum(IN_EDGE_WEIGHT);
        if (value == null) {
            e.setUserDatum(IN_EDGE_WEIGHT, new MutableDouble(weight), UserData.SHARED);
        } else {
            value.setDoubleValue(weight);
        }
    }

    private void assignInlinkEdgeTransitionWeights() {
        Iterator vIt = this.getVertices().iterator();
        while (vIt.hasNext()) {
            Edge currentEdge;
            Vertex currentVertex = (Vertex)vIt.next();
            Set incomingEdges = currentVertex.getInEdges();
            double total = 0.0;
            Iterator edgeIt = incomingEdges.iterator();
            while (edgeIt.hasNext()) {
                currentEdge = (Edge)edgeIt.next();
                total += this.getEdgeWeight(currentEdge);
            }
            edgeIt = incomingEdges.iterator();
            while (edgeIt.hasNext()) {
                currentEdge = (Edge)edgeIt.next();
                double weight = this.getEdgeWeight(currentEdge);
                this.setInEdgeWeight(currentEdge, weight / total);
            }
        }
    }

    public String getRankScoreKey() {
        return this.mKeyToUseForRanking;
    }

    public double getRankScore(Element v) {
        return this.getRankScore(v, this.mKeyToUseForRanking);
    }

    protected double getRankScore(Element v, String key) {
        return ((MutableDouble)v.getUserDatum(key)).doubleValue();
    }

    protected double getPreviousAuthorityScore(Element v) {
        return ((MutableDouble)this.mPreviousAuthorityScores.get(v)).doubleValue();
    }

    protected double getPreviousHubScore(Element v) {
        return ((MutableDouble)this.mPreviousHubScores.get(v)).doubleValue();
    }

    protected void setRankScore(Element v, double rankValue, String key) {
        MutableDouble value = (MutableDouble)v.getUserDatum(key);
        if (value == null) {
            v.setUserDatum(key, new MutableDouble(rankValue), UserData.SHARED);
        } else {
            value.setDoubleValue(rankValue);
        }
    }

    protected void setRankScore(Element v, double rankValue) {
        this.setRankScore(v, rankValue, this.mKeyToUseForRanking);
    }

    protected double evaluateIteration() {
        this.updatePreviousScores();
        this.updateAuthorityRankings();
        this.updateHubRankings();
        double hubMSE = 0.0;
        double authorityMSE = 0.0;
        int numVertices = this.mReachableVertices.size();
        Iterator vIt = this.mReachableVertices.iterator();
        while (vIt.hasNext()) {
            Vertex currentVertex = (Vertex)vIt.next();
            double currentAuthorityScore = this.getRankScore(currentVertex, AUTHORITY_KEY);
            double currentHubScore = this.getRankScore(currentVertex, HUB_KEY);
            double previousAuthorityScore = this.getPreviousAuthorityScore(currentVertex);
            double previousHubScore = this.getPreviousHubScore(currentVertex);
            hubMSE += Math.pow(currentHubScore - previousHubScore, 2.0);
            authorityMSE += Math.pow(currentAuthorityScore - previousAuthorityScore, 2.0);
        }
        hubMSE = Math.pow(hubMSE / (double)numVertices, 0.5);
        authorityMSE = Math.pow(authorityMSE / (double)numVertices, 0.5);
        return hubMSE + authorityMSE;
    }

    public void setUseAuthorityForRanking(boolean useAuthorityForRanking) {
        this.mKeyToUseForRanking = useAuthorityForRanking ? AUTHORITY_KEY : HUB_KEY;
    }

    private double computeSum(Vertex v, String key) {
        double currentWeight;
        Set edges = null;
        String oppositeKey = null;
        if (key.equals(HUB_KEY)) {
            edges = v.getOutEdges();
            oppositeKey = AUTHORITY_KEY;
        } else {
            edges = v.getInEdges();
            oppositeKey = HUB_KEY;
        }
        double sum = 0.0;
        Iterator edgeIt = edges.iterator();
        while (edgeIt.hasNext()) {
            Edge e = (Edge)edgeIt.next();
            currentWeight = 0.0;
            currentWeight = key.equals(AUTHORITY_KEY) ? this.getEdgeWeight(e) : this.getInEdgeWeight(e);
            sum += this.getRankScore(e.getOpposite(v), oppositeKey) * currentWeight;
        }
        if (this.getPriorRankScore(v) > 0.0 && key.equals(AUTHORITY_KEY)) {
            Iterator leafIt = this.mLeafNodes.iterator();
            while (leafIt.hasNext()) {
                Vertex leafNode = (Vertex)leafIt.next();
                currentWeight = this.getPriorRankScore(v);
                sum += this.getRankScore(leafNode, oppositeKey) * currentWeight;
            }
        }
        return sum;
    }

    protected void updateAuthorityRankings() {
        double authoritySum = 0.0;
        Iterator vertexIt = this.mReachableVertices.iterator();
        while (vertexIt.hasNext()) {
            Vertex currentVertex = (Vertex)vertexIt.next();
            double newAuthorityScore = this.computeSum(currentVertex, AUTHORITY_KEY) * (1.0 - this.mBeta) + this.mBeta * this.getPriorRankScore(currentVertex);
            authoritySum += newAuthorityScore;
            this.setRankScore(currentVertex, newAuthorityScore, AUTHORITY_KEY);
        }
        if (!NumericalPrecision.equal(authoritySum, 1.0, 0.1)) {
            System.err.println("HITS With Priors scores can not be generrated because the specified graph is not connected.");
            System.err.println("Authority Sum: " + authoritySum);
        }
    }

    protected void updateHubRankings() {
        double hubSum = 0.0;
        Iterator vertexIt = this.mReachableVertices.iterator();
        while (vertexIt.hasNext()) {
            Vertex currentVertex = (Vertex)vertexIt.next();
            double newHubScore = this.computeSum(currentVertex, HUB_KEY) * (1.0 - this.mBeta) + this.mBeta * this.getPriorRankScore(currentVertex);
            hubSum += newHubScore;
            this.setRankScore(currentVertex, newHubScore, HUB_KEY);
        }
        if (!NumericalPrecision.equal(hubSum, 1.0, 0.1)) {
            System.err.println("HITS With Priors scores can not be generrated because the specified graph is not connected.");
            System.err.println("Hub Sum: " + hubSum);
        }
    }

    protected void updatePreviousScores() {
        Iterator vIt = this.getVertices().iterator();
        while (vIt.hasNext()) {
            Vertex currentVertex = (Vertex)vIt.next();
            MutableDouble previousAuthorityScore = (MutableDouble)this.mPreviousAuthorityScores.get(currentVertex);
            double currentAuthorityScore = this.getRankScore(currentVertex, AUTHORITY_KEY);
            previousAuthorityScore.setDoubleValue(currentAuthorityScore);
            MutableDouble previousHubScore = (MutableDouble)this.mPreviousHubScores.get(currentVertex);
            double currentHubScore = this.getRankScore(currentVertex, HUB_KEY);
            previousHubScore.setDoubleValue(currentHubScore);
        }
    }
}

