/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.impl;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.Element;
import edu.uci.ics.jung.graph.impl.AbstractArchetypeGraph;
import edu.uci.ics.jung.utils.GeneralUtils;
import edu.uci.ics.jung.utils.UserDataDelegate;
import java.lang.ref.WeakReference;
import java.util.Map;

public abstract class AbstractElement
extends UserDataDelegate
implements Element,
Cloneable {
    protected WeakReference m_Graph;
    protected int id = -1;

    public ArchetypeGraph getGraph() {
        if (this.m_Graph == null) {
            return null;
        }
        ArchetypeGraph g = (ArchetypeGraph)this.m_Graph.get();
        return g;
    }

    protected void addGraph_internal(AbstractArchetypeGraph g) {
        if (this.m_Graph != null) {
            throw new FatalException("Internal error: element " + this + " is already part of graph " + this.getGraph());
        }
        this.m_Graph = new WeakReference<AbstractArchetypeGraph>(g);
    }

    protected void removeGraph_internal() {
        this.m_Graph = null;
    }

    int getID() {
        return this.id;
    }

    public int hashCode() {
        return GeneralUtils.hash(this.id);
    }

    void checkIDs(Map ids) {
        Integer newIndex = new Integer(this.getID());
        if (ids.containsKey(newIndex)) {
            throw new IllegalArgumentException("An equivalent element already exists in this graph");
        }
        ids.put(newIndex, this);
    }

    protected void initialize() {
        this.m_Graph = null;
    }
}

