/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.SparseVertex;
import edu.uci.ics.jung.graph.impl.UndirectedSparseEdge;
import edu.uci.ics.jung.visualization.ArrowFactory;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.PickSupport;
import edu.uci.ics.jung.visualization.SettableVertexLocationFunction;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.util.Iterator;

public class EditingGraphMousePlugin
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    SettableVertexLocationFunction vertexLocations;
    Vertex startVertex;
    Point2D down;
    CubicCurve2D rawEdge = new CubicCurve2D.Float();
    Shape edgeShape;
    Shape rawArrowShape;
    Shape arrowShape;
    VisualizationViewer.Paintable edgePaintable;
    VisualizationViewer.Paintable arrowPaintable;
    boolean edgeIsDirected;

    public EditingGraphMousePlugin() {
        this(16);
    }

    public EditingGraphMousePlugin(int modifiers) {
        super(modifiers);
        this.rawEdge.setCurve(0.0, 0.0, 0.33f, 100.0, 0.66f, -50.0, 1.0, 0.0);
        this.rawArrowShape = ArrowFactory.getNotchedArrow(20.0f, 16.0f, 8.0f);
        this.edgePaintable = new EdgePaintable();
        this.arrowPaintable = new ArrowPaintable();
    }

    public void setVertexLocations(SettableVertexLocationFunction vertexLocations) {
        this.vertexLocations = vertexLocations;
    }

    public boolean checkModifiers(MouseEvent e) {
        return (e.getModifiers() & this.modifiers) != 0;
    }

    public void mousePressed(MouseEvent e) {
        if (this.checkModifiers(e)) {
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            Point2D p = vv.inverseViewTransform(e.getPoint());
            PickSupport pickSupport = vv.getPickSupport();
            if (pickSupport != null) {
                Vertex vertex = pickSupport.getVertex(p.getX(), p.getY());
                if (vertex != null) {
                    this.startVertex = vertex;
                    this.down = e.getPoint();
                    this.transformEdgeShape(this.down, this.down);
                    vv.addPostRenderPaintable(this.edgePaintable);
                    if ((e.getModifiers() & 1) != 0) {
                        this.edgeIsDirected = true;
                        this.transformArrowShape(this.down, e.getPoint());
                        vv.addPostRenderPaintable(this.arrowPaintable);
                    }
                } else {
                    Graph graph = vv.getGraphLayout().getGraph();
                    SparseVertex newVertex = new SparseVertex();
                    this.vertexLocations.setLocation(newVertex, vv.inverseTransform(e.getPoint()));
                    Layout layout = vv.getGraphLayout();
                    Iterator iterator = graph.getVertices().iterator();
                    while (iterator.hasNext()) {
                        layout.lockVertex((Vertex)iterator.next());
                    }
                    graph.addVertex(newVertex);
                    vv.getModel().restart();
                    iterator = graph.getVertices().iterator();
                    while (iterator.hasNext()) {
                        layout.unlockVertex((Vertex)iterator.next());
                    }
                    vv.repaint();
                }
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.checkModifiers(e)) {
            Vertex vertex;
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            Point2D p = vv.inverseViewTransform(e.getPoint());
            PickSupport pickSupport = vv.getPickSupport();
            if (pickSupport != null && (vertex = pickSupport.getVertex(p.getX(), p.getY())) != null && this.startVertex != null) {
                Graph graph = vv.getGraphLayout().getGraph();
                if (this.edgeIsDirected) {
                    graph.addEdge(new DirectedSparseEdge(this.startVertex, vertex));
                } else {
                    graph.addEdge(new UndirectedSparseEdge(this.startVertex, vertex));
                }
                vv.repaint();
            }
            this.startVertex = null;
            this.down = null;
            this.edgeIsDirected = false;
            vv.removePostRenderPaintable(this.edgePaintable);
            vv.removePostRenderPaintable(this.arrowPaintable);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.checkModifiers(e) && this.startVertex != null) {
            this.transformEdgeShape(this.down, e.getPoint());
            if (this.edgeIsDirected) {
                this.transformArrowShape(this.down, e.getPoint());
            }
        }
    }

    private void transformEdgeShape(Point2D down, Point2D out) {
        float x1 = (float)down.getX();
        float y1 = (float)down.getY();
        float x2 = (float)out.getX();
        float y2 = (float)out.getY();
        AffineTransform xform = AffineTransform.getTranslateInstance(x1, y1);
        float dx = x2 - x1;
        float dy = y2 - y1;
        float thetaRadians = (float)Math.atan2(dy, dx);
        xform.rotate(thetaRadians);
        float dist = (float)Math.sqrt(dx * dx + dy * dy);
        xform.scale((double)dist / this.rawEdge.getBounds().getWidth(), 1.0);
        this.edgeShape = xform.createTransformedShape(this.rawEdge);
    }

    private void transformArrowShape(Point2D down, Point2D out) {
        float x1 = (float)down.getX();
        float y1 = (float)down.getY();
        float x2 = (float)out.getX();
        float y2 = (float)out.getY();
        AffineTransform xform = AffineTransform.getTranslateInstance(x2, y2);
        float dx = x2 - x1;
        float dy = y2 - y1;
        float thetaRadians = (float)Math.atan2(dy, dx);
        xform.rotate(thetaRadians);
        this.arrowShape = xform.createTransformedShape(this.rawArrowShape);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    class ArrowPaintable
    implements VisualizationViewer.Paintable {
        ArrowPaintable() {
        }

        public void paint(Graphics g) {
            if (EditingGraphMousePlugin.this.arrowShape != null) {
                Color oldColor = g.getColor();
                g.setColor(Color.black);
                ((Graphics2D)g).fill(EditingGraphMousePlugin.this.arrowShape);
                g.setColor(oldColor);
            }
        }

        public boolean useTransform() {
            return false;
        }
    }

    class EdgePaintable
    implements VisualizationViewer.Paintable {
        EdgePaintable() {
        }

        public void paint(Graphics g) {
            if (EditingGraphMousePlugin.this.edgeShape != null) {
                Color oldColor = g.getColor();
                g.setColor(Color.black);
                ((Graphics2D)g).draw(EditingGraphMousePlugin.this.edgeShape);
                g.setColor(oldColor);
            }
        }

        public boolean useTransform() {
            return false;
        }
    }
}

