/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTImportDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTPackageDeclaration;

public class ImportFromSamePackageRule
extends AbstractRule {
    private String packageName;

    public Object visit(ASTCompilationUnit node, Object data) {
        this.packageName = null;
        return super.visit(node, data);
    }

    public Object visit(ASTPackageDeclaration node, Object data) {
        this.packageName = ((ASTName)node.jjtGetChild(0)).getImage();
        return data;
    }

    public Object visit(ASTImportDeclaration node, Object data) {
        ASTName nameNode = node.getImportedNameNode();
        RuleContext ctx = (RuleContext)data;
        if (this.packageName != null && !node.isImportOnDemand() && this.packageName.equals(this.getPackageName(nameNode.getImage()))) {
            this.addViolation(ctx, node);
        }
        if (this.packageName == null && this.getPackageName(nameNode.getImage()).equals("")) {
            this.addViolation(ctx, node);
        }
        return data;
    }

    private void addViolation(RuleContext ctx, ASTImportDeclaration node) {
        ctx.getReport().addRuleViolation(this.createRuleViolation(ctx, node.getBeginLine()));
    }

    private String getPackageName(String importName) {
        if (importName.indexOf(46) == -1) {
            return "";
        }
        int lastDot = importName.lastIndexOf(46);
        return importName.substring(0, lastDot);
    }
}

