/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.stat;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.stat.DataPoint;
import net.sourceforge.pmd.stat.Metric;

public abstract class StatisticalRule
extends AbstractRule {
    public static double DELTA = 5.0E-6;
    private SortedSet dataPoints = new TreeSet();
    private int count = 0;
    private double total = 0.0;
    private double totalSquared = 0.0;

    public void addDataPoint(DataPoint point) {
        ++this.count;
        this.total += point.getScore();
        this.totalSquared += point.getScore() * point.getScore();
        this.dataPoints.add(point);
    }

    public void apply(List acus, RuleContext ctx) {
        double mMin;
        this.visitAll(acus, ctx);
        double minimum = 0.0;
        if (this.hasProperty("sigma")) {
            double deviation = this.getStdDev();
            double sigma = this.getDoubleProperty("sigma");
            minimum = this.getMean() + sigma * deviation;
        }
        if (this.hasProperty("minimum") && (mMin = this.getDoubleProperty("minimum")) > minimum) {
            minimum = mMin;
        }
        SortedSet newPoints = this.applyMinimumValue(this.dataPoints, minimum);
        if (this.hasProperty("topscore")) {
            int topScore = this.getIntProperty("topscore");
            if (newPoints.size() >= topScore) {
                newPoints = this.applyTopScore(newPoints, topScore);
            }
        }
        this.makeViolations(ctx, newPoints);
        double low = 0.0;
        double high = 0.0;
        if (!this.dataPoints.isEmpty()) {
            low = ((DataPoint)this.dataPoints.first()).getScore();
            high = ((DataPoint)this.dataPoints.last()).getScore();
        }
        ctx.getReport().addMetric(new Metric(this.getName(), this.count, this.total, low, high, this.getMean(), this.getStdDev()));
        this.dataPoints.clear();
    }

    protected double getMean() {
        return this.total / (double)this.count;
    }

    /*
     * Unable to fully structure code
     */
    protected double getStdDev() {
        points = this.dataPoints.iterator();
        mean = this.getMean();
        deltaSq = 0.0;
        if (this.dataPoints.size() >= 2) ** GOTO lbl8
        return NaN;
lbl-1000:
        // 1 sources

        {
            point = (DataPoint)points.next();
            deltaSq += (point.getScore() - mean) * (point.getScore() - mean);
lbl8:
            // 2 sources

            ** while (points.hasNext())
        }
lbl9:
        // 1 sources

        return Math.sqrt(deltaSq / (double)(this.dataPoints.size() - 1));
    }

    protected SortedSet applyMinimumValue(SortedSet pointSet, double minValue) {
        Iterator points = pointSet.iterator();
        TreeSet<DataPoint> RC = new TreeSet<DataPoint>();
        while (points.hasNext()) {
            DataPoint point = (DataPoint)points.next();
            if (!(point.getScore() > minValue - DELTA)) continue;
            RC.add(point);
        }
        return RC;
    }

    protected SortedSet applyTopScore(SortedSet points, int topScore) {
        TreeSet<DataPoint> RC = new TreeSet<DataPoint>();
        int i = 0;
        while (i < topScore) {
            DataPoint point = (DataPoint)points.last();
            points.remove(point);
            RC.add(point);
            ++i;
        }
        return RC;
    }

    protected void makeViolations(RuleContext ctx, Set dataPoints) {
        Iterator points = dataPoints.iterator();
        while (points.hasNext()) {
            DataPoint point = (DataPoint)points.next();
            ctx.getReport().addRuleViolation(this.createRuleViolation(ctx, point.getLineNumber(), point.getMessage()));
        }
    }
}

