/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import java.io.File;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.swingui.MessageDialog;
import net.sourceforge.pmd.swingui.PMDViewer;
import net.sourceforge.pmd.swingui.Preferences;
import net.sourceforge.pmd.swingui.ResultsViewer;
import net.sourceforge.pmd.swingui.event.DirectoryTableEvent;
import net.sourceforge.pmd.swingui.event.DirectoryTableEventListener;
import net.sourceforge.pmd.swingui.event.ListenerList;
import net.sourceforge.pmd.swingui.event.RulesInMemoryEvent;
import net.sourceforge.pmd.swingui.event.RulesInMemoryEventListener;

class AnalysisResultsViewer
extends ResultsViewer {
    private RuleSet m_ruleSet;

    protected AnalysisResultsViewer() {
        ListenerList.addListener(new DirectoryTableEventHandler());
        ListenerList.addListener(new RulesInMemoryEventHandler());
    }

    private class RulesInMemoryEventHandler
    implements RulesInMemoryEventListener {
        private RulesInMemoryEventHandler() {
        }

        public void requestAllRules(RulesInMemoryEvent event) {
        }

        public void requestIncludedRules(RulesInMemoryEvent event) {
        }

        public void returnedRules(RulesInMemoryEvent event) {
            AnalysisResultsViewer.this.m_ruleSet = event.getRules();
        }
    }

    private class DirectoryTableEventHandler
    implements DirectoryTableEventListener {
        private DirectoryTableEventHandler() {
        }

        public void requestSelectedFile(DirectoryTableEvent event) {
        }

        public void fileSelectionChanged(DirectoryTableEvent event) {
            try {
                File[] file = new File[]{event.getSelectedFile()};
                int priority = Preferences.getPreferences().getLowestPriorityForAnalysis();
                RulesInMemoryEvent.notifyRequestIncludedRules(this, priority);
                AnalysisResultsViewer.this.analyze(file, AnalysisResultsViewer.this.m_ruleSet);
            }
            catch (PMDException pmdException) {
                MessageDialog.show(PMDViewer.getViewer(), pmdException.getMessage(), pmdException.getReason());
            }
        }

        public void fileSelected(DirectoryTableEvent event) {
        }
    }
}

