/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.swingui.ComponentFactory;
import net.sourceforge.pmd.swingui.HelpMenu;
import net.sourceforge.pmd.swingui.MessageDialog;
import net.sourceforge.pmd.swingui.PMDViewer;
import net.sourceforge.pmd.swingui.Preferences;

class PreferencesEditor
extends JPanel {
    private JTextArea m_currentPathToPMD;
    private JTextArea m_userPathToPMD;
    private JTextArea m_sharedPathToPMD;
    private JTextArea m_analysisResultsPath;
    private JComboBox m_lowestPriorityForAnalysis;
    private JMenuBar m_menuBar;

    protected PreferencesEditor() throws PMDException {
        super(new BorderLayout());
        this.add((Component)this.createContentPanel(), "Center");
        this.createMenuBar();
    }

    private JScrollPane createContentPanel() throws PMDException {
        JPanel contentPanel = new JPanel(new BorderLayout());
        EmptyBorder emptyBorder = new EmptyBorder(100, 100, 100, 100);
        EtchedBorder etchedBorder = new EtchedBorder(1);
        CompoundBorder compoundBorder = new CompoundBorder(etchedBorder, emptyBorder);
        contentPanel.setBorder(compoundBorder);
        contentPanel.add((Component)this.createDataPanel(), "North");
        return ComponentFactory.createScrollPane(contentPanel);
    }

    private JPanel createDataPanel() throws PMDException {
        JPanel dataPanel = new JPanel(new GridBagLayout());
        EmptyBorder emptyBorder = new EmptyBorder(1, 1, 1, 1);
        EtchedBorder etchedBorder = new EtchedBorder(0);
        CompoundBorder compoundBorder = new CompoundBorder(etchedBorder, emptyBorder);
        compoundBorder = new CompoundBorder(compoundBorder, etchedBorder);
        emptyBorder = new EmptyBorder(10, 10, 10, 10);
        compoundBorder = new CompoundBorder(compoundBorder, emptyBorder);
        dataPanel.setBorder(compoundBorder);
        Preferences preferences = Preferences.getPreferences();
        int row = 0;
        this.createLabel("Current Path to PMD Directory", dataPanel, row, 0);
        String currentPath = preferences.getCurrentPathToPMD();
        this.m_currentPathToPMD = this.createTextArea(currentPath, dataPanel, row, 1);
        this.createFileButton(dataPanel, row, 2, this.m_currentPathToPMD);
        this.createLabel("User Path to PMD Directory", dataPanel, ++row, 0);
        String userPath = preferences.getUserPathToPMD();
        this.m_userPathToPMD = this.createTextArea(userPath, dataPanel, row, 1);
        this.createFileButton(dataPanel, row, 2, this.m_userPathToPMD);
        this.createLabel("Shared Path to PMD Directory", dataPanel, ++row, 0);
        String sharedPath = preferences.getSharedPathToPMD();
        this.m_sharedPathToPMD = this.createTextArea(sharedPath, dataPanel, row, 1);
        this.createFileButton(dataPanel, row, 2, this.m_sharedPathToPMD);
        this.createLabel("Analysis Results Files Path", dataPanel, ++row, 0);
        String analysisResultsPath = preferences.getAnalysisResultsPath();
        this.m_analysisResultsPath = this.createTextArea(analysisResultsPath, dataPanel, row, 1);
        this.createFileButton(dataPanel, row, 2, this.m_analysisResultsPath);
        this.createLabel("Lowest Priority for Analysis", dataPanel, ++row, 0);
        int priority = preferences.getLowestPriorityForAnalysis();
        this.m_lowestPriorityForAnalysis = this.createPriorityDropDownList(priority, dataPanel, row, 1);
        return dataPanel;
    }

    private void createLabel(String text, JPanel dataPanel, int row, int column) {
        JLabel label = new JLabel(text);
        label.setFont(UIManager.getFont("labelFont"));
        label.setHorizontalAlignment(4);
        label.setForeground(UIManager.getColor("pmdBlue"));
        GridBagLayout layout = (GridBagLayout)dataPanel.getLayout();
        GridBagConstraints constraints = layout.getConstraints(label);
        constraints.gridx = column;
        constraints.gridy = row;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 12;
        constraints.fill = 0;
        constraints.insets = new Insets(2, 2, 2, 2);
        dataPanel.add((Component)label, constraints);
    }

    private JTextArea createTextArea(String text, JPanel dataPanel, int row, int column) {
        JTextArea textArea = ComponentFactory.createTextArea(text);
        JScrollPane scrollPane = ComponentFactory.createScrollPane(textArea);
        Font font = textArea.getFont();
        FontMetrics fontMetrics = textArea.getFontMetrics(font);
        int width = 400;
        int height = 3 * fontMetrics.getHeight() + 5;
        Dimension size = new Dimension(width, height);
        scrollPane.setSize(size);
        scrollPane.setMinimumSize(size);
        scrollPane.setPreferredSize(size);
        GridBagLayout layout = (GridBagLayout)dataPanel.getLayout();
        GridBagConstraints constraints = layout.getConstraints(scrollPane);
        constraints.gridx = column;
        constraints.gridy = row;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 17;
        constraints.fill = 1;
        constraints.insets = new Insets(2, 2, 2, 2);
        dataPanel.add((Component)scrollPane, constraints);
        return textArea;
    }

    private void createFileButton(JPanel dataPanel, int row, int column, JTextArea textArea) {
        JButton button = ComponentFactory.createButton("Find Directory");
        FontMetrics fontMetrics = button.getFontMetrics(button.getFont());
        int width = fontMetrics.stringWidth(button.getText()) + 50;
        Dimension size = new Dimension(width, button.getHeight());
        button.setPreferredSize(size);
        button.setMinimumSize(size);
        button.setMaximumSize(size);
        button.setBackground(UIManager.getColor("pmdBlue"));
        button.setForeground(Color.white);
        button.addActionListener(new FileButtonActionListener(textArea));
        GridBagLayout layout = (GridBagLayout)dataPanel.getLayout();
        GridBagConstraints constraints = layout.getConstraints(button);
        constraints.gridx = column;
        constraints.gridy = row;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(2, 2, 2, 2);
        dataPanel.add((Component)button, constraints);
    }

    private JComboBox createPriorityDropDownList(int priority, JPanel dataPanel, int row, int column) {
        JComboBox<String> priorityLevel = new JComboBox<String>(Rule.PRIORITIES);
        priorityLevel.setSelectedIndex(priority - 1);
        GridBagLayout layout = (GridBagLayout)dataPanel.getLayout();
        GridBagConstraints constraints = layout.getConstraints(priorityLevel);
        constraints.gridx = column;
        constraints.gridy = row;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(2, 2, 2, 2);
        dataPanel.add(priorityLevel, constraints);
        return priorityLevel;
    }

    private void createMenuBar() {
        this.m_menuBar = new JMenuBar();
        this.m_menuBar.add(new FileMenu());
        this.m_menuBar.add(new HelpMenu());
    }

    protected void setMenuBar() {
        PMDViewer.getViewer().setJMenuBar(this.m_menuBar);
    }

    public void adjustSplitPaneDividerLocation() {
    }

    private class ExitActionListener
    implements ActionListener {
        private ExitActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            System.exit(0);
        }
    }

    private class FileMenu
    extends JMenu {
        private FileMenu() {
            super("File");
            this.setMnemonic('F');
            Icon icon = UIManager.getIcon("save");
            JMenuItem menuItem = new JMenuItem("Save Changes", icon);
            menuItem.addActionListener(new SaveActionListener());
            menuItem.setMnemonic('S');
            menuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
            this.add(menuItem);
            this.add(new JSeparator());
            menuItem = new JMenuItem("Exit...");
            menuItem.addActionListener(new ExitActionListener());
            menuItem.setMnemonic('X');
            this.add(menuItem);
        }
    }

    private class FileButtonActionListener
    implements ActionListener {
        private JTextArea m_textArea;

        private FileButtonActionListener(JTextArea textArea) {
            this.m_textArea = textArea;
        }

        public void actionPerformed(ActionEvent event) {
            File file = new File(this.m_textArea.getText());
            if (!file.exists()) {
                file = new File(System.getProperty("user.home"));
            } else if (!file.isDirectory()) {
                file = file.getParentFile();
            }
            JFileChooser fileChooser = new JFileChooser(file);
            fileChooser.setFileSelectionMode(1);
            fileChooser.setApproveButtonText("Select");
            fileChooser.setMinimumSize(new Dimension(500, 500));
            if (fileChooser.showOpenDialog(PMDViewer.getViewer()) == 0) {
                file = fileChooser.getSelectedFile();
                this.m_textArea.setText(file.getPath());
            }
        }
    }

    private class CancelButtonActionListener
    implements ActionListener {
        private CancelButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            PreferencesEditor.this.setVisible(false);
        }
    }

    private class SaveActionListener
    implements ActionListener {
        private SaveActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            try {
                Preferences preferences = Preferences.getPreferences();
                preferences.setCurrentPathToPMD(PreferencesEditor.this.m_currentPathToPMD.getText());
                preferences.setUserPathToPMD(PreferencesEditor.this.m_userPathToPMD.getText());
                preferences.setSharedPathToPMD(PreferencesEditor.this.m_sharedPathToPMD.getText());
                preferences.setLowestPriorityForAnalysis(PreferencesEditor.this.m_lowestPriorityForAnalysis.getSelectedIndex() + 1);
                preferences.save();
            }
            catch (PMDException pmdException) {
                String message = pmdException.getMessage();
                Exception exception = pmdException.getReason();
                MessageDialog.show(PMDViewer.getViewer(), message, exception);
            }
            PreferencesEditor.this.setVisible(false);
        }
    }
}

