/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.swingui.Constants;
import net.sourceforge.pmd.swingui.MessageDialog;
import net.sourceforge.pmd.swingui.PMDViewer;
import net.sourceforge.pmd.swingui.RulesClassSelectDialog;
import net.sourceforge.pmd.swingui.RulesTreeModel;
import net.sourceforge.pmd.swingui.RulesTreeNode;
import net.sourceforge.pmd.swingui.event.ListenerList;
import net.sourceforge.pmd.swingui.event.RulesEditingEvent;
import net.sourceforge.pmd.swingui.event.RulesEditingEventListener;

class RulesTree
extends JTree
implements Constants {
    private Color m_background;
    private boolean m_disablePopupMenu;
    private boolean m_disableEditing;
    private final String UNTITLED = "Untitled";
    static /* synthetic */ Class class$net$sourceforge$pmd$AbstractRule;

    protected RulesTree() throws PMDException {
        super(RulesTreeModel.get());
        this.setRootVisible(true);
        this.setBorder(BorderFactory.createEtchedBorder(1));
        this.setCellRenderer(new TreeNodeRenderer());
        this.setCellEditor(new TreeCellEditor());
        this.m_background = UIManager.getColor("pmdTreeBackground");
        this.expandNode(this.getRootNode());
        TreePath treePath = new TreePath(this.getRootNode().getPath());
        this.setSelectionPath(treePath);
        this.setBackground(this.m_background);
        this.addMouseListener(new RulesTreeMouseListener());
        ListenerList.addListener(new RulesEditingEventHandler());
    }

    protected RulesTreeNode getRootNode() {
        return (RulesTreeNode)((RulesTreeModel)this.getModel()).getRoot();
    }

    public void updateUI() {
        super.updateUI();
        this.setBackground(this.m_background);
    }

    protected void expandNode(RulesTreeNode node) {
        TreePath treePath = new TreePath(node.getPath());
        this.expandPath(treePath);
    }

    protected RulesTreeNode getSelectedNode() {
        TreePath treePath = this.getSelectionPath();
        return treePath == null ? null : (RulesTreeNode)treePath.getLastPathComponent();
    }

    protected boolean isExpanded(RulesTreeNode node) {
        TreePath treePath = new TreePath(node.getPath());
        return this.isExpanded(treePath);
    }

    protected void setDisablePopupMenu(boolean setting) {
        this.m_disablePopupMenu = setting;
    }

    protected void setDisableEditing(boolean setting) {
        this.m_disableEditing = setting;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class UpdateUI
    implements Runnable {
        private UpdateUI() {
        }

        public void run() {
            RulesTree.this.updateUI();
        }
    }

    private class RulesEditingEventHandler
    implements RulesEditingEventListener {
        private RulesEditingEventHandler() {
        }

        public void saveData(RulesEditingEvent event) {
            SwingUtilities.invokeLater(new UpdateUI());
        }

        public void loadData(RulesEditingEvent event) {
        }
    }

    private class TreeNodeRenderer
    extends DefaultTreeCellRenderer {
        private Icon m_defaultClosedIcon = this.getDefaultClosedIcon();
        private Icon m_defaultLeafIcon = this.getDefaultLeafIcon();
        private Icon m_defaultOpenIcon = this.getDefaultOpenIcon();
        private Icon m_documentIcon = UIManager.getIcon("document");
        private Font m_plainFont;
        private Font m_italicFont;

        protected TreeNodeRenderer() {
            Font font = RulesTree.this.getFont();
            this.m_plainFont = new Font(font.getName(), 0, font.getSize());
            this.m_italicFont = new Font(font.getName(), 2, font.getSize());
            this.setBackgroundNonSelectionColor(UIManager.getColor("pmdTreeBackground"));
            this.setBackgroundSelectionColor(Color.yellow);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object object, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
            RulesTreeNode treeNode = (RulesTreeNode)object;
            if (treeNode.isProperty()) {
                this.setClosedIcon(this.m_defaultClosedIcon);
                this.setLeafIcon(this.m_documentIcon);
                this.setOpenIcon(this.m_defaultOpenIcon);
            } else {
                this.setClosedIcon(this.m_defaultClosedIcon);
                this.setLeafIcon(this.m_defaultClosedIcon);
                this.setOpenIcon(this.m_defaultOpenIcon);
            }
            if (treeNode.include() && treeNode.includeAncestor()) {
                this.setTextNonSelectionColor(Color.blue);
                this.setTextSelectionColor(Color.blue);
                this.setFont(this.m_plainFont);
            } else {
                this.setTextNonSelectionColor(Color.black);
                this.setTextSelectionColor(Color.black);
                this.setFont(this.m_italicFont);
            }
            this.updateUI();
            return super.getTreeCellRendererComponent(tree, object, isSelected, isExpanded, isLeaf, row, hasFocus);
        }

        public void paint(Graphics graphics) {
            int x = this.getX();
            int y = this.getY();
            int width = this.getWidth();
            int height = this.getHeight();
            graphics.clearRect(x, y, width, height);
            super.paint(graphics);
        }
    }

    private class TreeCellEditor
    extends DefaultTreeCellEditor {
        private TreeCellEditor() {
            super(RulesTree.this, (DefaultTreeCellRenderer)RulesTree.this.getCellRenderer());
        }

        public boolean isCellEditable(EventObject event) {
            return false;
        }
    }

    private class RemoveRulePropertyActionListener
    implements ActionListener {
        private RemoveRulePropertyActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            RulesTreeNode propertyNode = RulesTree.this.getSelectedNode();
            String propertyName = propertyNode.getName();
            String template = "Do you really want to remove the property \"{0}\"?\nThe remove cannot be undone.";
            Object[] args = new String[]{propertyName};
            String message = MessageFormat.format(template, args);
            if (MessageDialog.answerIsYes(PMDViewer.getViewer(), message)) {
                DefaultTreeModel treeModel = (DefaultTreeModel)RulesTree.this.getModel();
                treeModel.removeNodeFromParent(propertyNode);
            }
        }
    }

    private class AddRulePropertyActionListener
    implements ActionListener {
        private AddRulePropertyActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            String propertyName = "Untitled";
            int counter = 0;
            RulesTree rulesTree = RulesTree.this;
            RulesTreeNode ruleNode = rulesTree.getSelectedNode();
            while (ruleNode.getChildNode(propertyName) != null) {
                propertyName = "Untitled-" + ++counter;
            }
            RulesTreeNode propertyNode = new RulesTreeNode(ruleNode, propertyName, "", "String");
            DefaultTreeModel treeModel = (DefaultTreeModel)rulesTree.getModel();
            ruleNode.add(propertyNode);
            treeModel.nodeStructureChanged(ruleNode);
            if (!rulesTree.isExpanded(ruleNode)) {
                rulesTree.expandNode(ruleNode);
            }
            ruleNode.sortChildren();
        }
    }

    private class RemoveRuleActionListener
    implements ActionListener {
        private RemoveRuleActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            RulesTreeNode ruleNode = RulesTree.this.getSelectedNode();
            String ruleName = ruleNode.getName();
            String template = "Do you really want to remove the rule \"{0}\"?\nThe remove cannot be undone.";
            Object[] args = new String[]{ruleName};
            String message = MessageFormat.format(template, args);
            if (MessageDialog.answerIsYes(PMDViewer.getViewer(), message)) {
                DefaultTreeModel treeModel = (DefaultTreeModel)RulesTree.this.getModel();
                treeModel.removeNodeFromParent(ruleNode);
            }
        }
    }

    private class RuleClassLoader
    extends ClassLoader {
        private RuleClassLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Class loadClass(File file) {
            Class<?> clazz;
            block20: {
                FileInputStream inputStream = null;
                clazz = null;
                try {
                    inputStream = new FileInputStream(file);
                    clazz = null;
                    if (inputStream == null) break block20;
                    int size = 10000;
                    int byteCount = 0;
                    byte[] buffer = new byte[10000];
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10000);
                    try {
                        while ((byteCount = inputStream.read(buffer)) > 0) {
                            byteArrayOutputStream.write(buffer, 0, byteCount);
                        }
                    }
                    catch (IOException exception) {
                        Class clazz2 = null;
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException exception2) {
                                inputStream = null;
                            }
                        }
                        return clazz2;
                    }
                    buffer = byteArrayOutputStream.toByteArray();
                    clazz = super.defineClass(null, buffer, 0, buffer.length);
                    if (clazz != null) {
                        this.resolveClass(clazz);
                    }
                }
                catch (FileNotFoundException exception) {
                    clazz = null;
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException exception) {
                            inputStream = null;
                        }
                    }
                }
            }
            return clazz;
        }
    }

    private class RulesFileFilter
    implements FileFilter {
        private RulesFileFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().endsWith(".class");
        }

        public String getDescription() {
            return "Rule Class Files";
        }
    }

    private class AddRuleActionListener
    implements ActionListener {
        private AddRuleActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            Rule rule = null;
            try {
                rule = this.getNewRuleFromUser();
            }
            catch (PMDException pmdException) {
                String message = pmdException.getMessage();
                Exception exception = pmdException.getReason();
                MessageDialog.show(PMDViewer.getViewer(), message, exception);
                return;
            }
            if (rule != null) {
                String baseRuleName;
                String className = rule.getClass().getName();
                int index = className.lastIndexOf(46) + 1;
                String ruleName = baseRuleName = className.substring(index);
                int counter = 0;
                RulesTree rulesTree = RulesTree.this;
                RulesTreeNode ruleSetNode = rulesTree.getSelectedNode();
                while (ruleSetNode.getChildNode(ruleName) != null) {
                    ruleName = baseRuleName + "-" + ++counter;
                }
                rule.setName(ruleName);
                RulesTreeNode ruleNode = new RulesTreeNode(ruleSetNode, rule);
                DefaultTreeModel treeModel = (DefaultTreeModel)rulesTree.getModel();
                ruleSetNode.add(ruleNode);
                treeModel.nodeStructureChanged(ruleSetNode);
                if (!rulesTree.isExpanded(ruleSetNode)) {
                    rulesTree.expandNode(ruleSetNode);
                }
                ruleSetNode.sortChildren();
                TreePath treePath = new TreePath(ruleNode.getPath());
                rulesTree.setSelectionPath(treePath);
            }
        }

        private Rule getNewRuleFromUser() throws PMDException {
            block4: {
                RulesClassSelectDialog dialog = new RulesClassSelectDialog(PMDViewer.getViewer());
                dialog.show();
                if (!dialog.selectWasPressed()) break block4;
                File selectedFile = dialog.getSelectedClassFile();
                RuleClassLoader classLoader = new RuleClassLoader();
                Class clazz = classLoader.loadClass(selectedFile);
                try {
                    Object object = clazz.newInstance();
                    if (object instanceof AbstractRule) {
                        return (Rule)object;
                    }
                    String abstractRuleClassName = (class$net$sourceforge$pmd$AbstractRule == null ? (class$net$sourceforge$pmd$AbstractRule = RulesTree.class$("net.sourceforge.pmd.AbstractRule")) : class$net$sourceforge$pmd$AbstractRule).getName();
                    String template = "The selected class \"{0}\" must subclass the abstract rule class \"{1}\".";
                    Object[] args = new String[]{clazz.getName(), abstractRuleClassName};
                    String message = MessageFormat.format(template, args);
                    MessageDialog.show(PMDViewer.getViewer(), message);
                }
                catch (InstantiationException exception) {
                    String template = "Could not instantiate class \"{0}\".";
                    Object[] args = new String[]{clazz.getName()};
                    String message = MessageFormat.format(template, args);
                    MessageDialog.show(PMDViewer.getViewer(), message, exception);
                }
                catch (IllegalAccessException exception) {
                    String template = "Encountered illegal access while instantiating class \"{0}\".";
                    Object[] args = new String[]{clazz.getName()};
                    String message = MessageFormat.format(template, args);
                    MessageDialog.show(PMDViewer.getViewer(), message, exception);
                }
            }
            return null;
        }
    }

    private class RemoveRuleSetActionListener
    implements ActionListener {
        private RemoveRuleSetActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            RulesTreeNode ruleSetNode = RulesTree.this.getSelectedNode();
            if (ruleSetNode != null) {
                String ruleSetName = ruleSetNode.getName();
                String template = "Do you really want to remove the rule set \"{0}\"?\nThe remove cannot be undone.";
                Object[] args = new String[]{ruleSetName};
                String message = MessageFormat.format(template, args);
                if (MessageDialog.answerIsYes(PMDViewer.getViewer(), message)) {
                    DefaultTreeModel treeModel = (DefaultTreeModel)RulesTree.this.getModel();
                    treeModel.removeNodeFromParent(ruleSetNode);
                }
            }
        }
    }

    private class AddRuleSetActionListener
    implements ActionListener {
        private AddRuleSetActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            RuleSet ruleSet = new RuleSet();
            String ruleSetName = "Untitled";
            int counter = 0;
            RulesTree rulesTree = RulesTree.this;
            RulesTreeNode rootNode = rulesTree.getSelectedNode();
            while (rootNode.getChildNode(ruleSetName) != null) {
                ruleSetName = "Untitled-" + ++counter;
            }
            ruleSet.setName(ruleSetName);
            RulesTreeNode ruleSetNode = new RulesTreeNode(ruleSet);
            DefaultTreeModel treeModel = (DefaultTreeModel)RulesTree.this.getModel();
            rootNode.add(ruleSetNode);
            treeModel.nodeStructureChanged(rootNode);
            if (!rulesTree.isExpanded(ruleSetNode)) {
                rulesTree.expandNode(ruleSetNode);
            }
            rootNode.sortChildren();
        }
    }

    private class IncludeActionListener
    implements ActionListener {
        private IncludeActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            JCheckBoxMenuItem includeMenuItem = (JCheckBoxMenuItem)event.getSource();
            RulesTree.this.getSelectedNode().setInclude(includeMenuItem.isSelected());
            RulesTree.this.updateUI();
            RulesTree.this.repaint();
        }
    }

    private class RulesTreeMouseListener
    extends MouseAdapter {
        private JMenuItem m_addRuleSetMenuItem;
        private JMenuItem m_removeRuleSetMenuItem;
        private JMenuItem m_addRuleMenuItem;
        private JMenuItem m_removeRuleMenuItem;
        private JMenuItem m_addPropertyMenuItem;
        private JMenuItem m_removePropertyMenuItem;
        private JMenuItem m_includeMenuItem;

        private RulesTreeMouseListener() {
        }

        public void mouseReleased(MouseEvent event) {
            if (event.isPopupTrigger()) {
                RulesTree rulesTree = RulesTree.this;
                Point location = event.getPoint();
                TreePath treePath = rulesTree.getPathForLocation(location.x, location.y);
                rulesTree.setSelectionPath(treePath);
                RulesTreeNode treeNode = (RulesTreeNode)treePath.getLastPathComponent();
                JPopupMenu popupMenu = null;
                if (treeNode.isRoot()) {
                    popupMenu = this.createRootPopupMenu();
                } else if (treeNode.isRuleSet()) {
                    popupMenu = this.createRuleSetPopupMenu();
                } else if (treeNode.isRule()) {
                    popupMenu = this.createRulePopupMenu();
                } else if (treeNode.isProperty()) {
                    popupMenu = this.createPropertyPopupMenu();
                }
                if (popupMenu != null) {
                    popupMenu.show(rulesTree, location.x, location.y);
                }
            }
        }

        private JPopupMenu createRootPopupMenu() {
            JPopupMenu popupMenu = this.createPopupMenu(false);
            this.m_addRuleSetMenuItem.setEnabled(true);
            this.m_removeRuleSetMenuItem.setEnabled(false);
            this.m_addRuleMenuItem.setEnabled(false);
            this.m_removeRuleMenuItem.setEnabled(false);
            this.m_addPropertyMenuItem.setEnabled(false);
            this.m_removePropertyMenuItem.setEnabled(false);
            return popupMenu;
        }

        private JPopupMenu createRuleSetPopupMenu() {
            JPopupMenu popupMenu = this.createPopupMenu(true);
            this.m_addRuleSetMenuItem.setEnabled(false);
            this.m_removeRuleSetMenuItem.setEnabled(true);
            this.m_addRuleMenuItem.setEnabled(true);
            this.m_removeRuleMenuItem.setEnabled(false);
            this.m_addPropertyMenuItem.setEnabled(false);
            this.m_removePropertyMenuItem.setEnabled(false);
            return popupMenu;
        }

        private JPopupMenu createRulePopupMenu() {
            JPopupMenu popupMenu = this.createPopupMenu(true);
            this.m_addRuleSetMenuItem.setEnabled(false);
            this.m_removeRuleSetMenuItem.setEnabled(false);
            this.m_addRuleMenuItem.setEnabled(false);
            this.m_removeRuleMenuItem.setEnabled(true);
            this.m_addPropertyMenuItem.setEnabled(true);
            this.m_removePropertyMenuItem.setEnabled(false);
            return popupMenu;
        }

        private JPopupMenu createPropertyPopupMenu() {
            JPopupMenu popupMenu = this.createPopupMenu(false);
            this.m_addRuleSetMenuItem.setEnabled(false);
            this.m_removeRuleSetMenuItem.setEnabled(false);
            this.m_addRuleMenuItem.setEnabled(false);
            this.m_removeRuleMenuItem.setEnabled(false);
            this.m_addPropertyMenuItem.setEnabled(false);
            this.m_removePropertyMenuItem.setEnabled(true);
            return popupMenu;
        }

        private JPopupMenu createPopupMenu(boolean addInclude) {
            JPopupMenu popupMenu = new JPopupMenu();
            this.m_addRuleSetMenuItem = new JMenuItem("Add Rule Set");
            this.m_addRuleSetMenuItem.addActionListener(new AddRuleSetActionListener());
            popupMenu.add(this.m_addRuleSetMenuItem);
            this.m_removeRuleSetMenuItem = new JMenuItem("Remove Rule Set");
            this.m_removeRuleSetMenuItem.addActionListener(new RemoveRuleSetActionListener());
            popupMenu.add(this.m_removeRuleSetMenuItem);
            popupMenu.add(new JSeparator());
            this.m_addRuleMenuItem = new JMenuItem("Add Rule");
            this.m_addRuleMenuItem.addActionListener(new AddRuleActionListener());
            popupMenu.add(this.m_addRuleMenuItem);
            this.m_removeRuleMenuItem = new JMenuItem("Remove Rule");
            this.m_removeRuleMenuItem.addActionListener(new RemoveRuleActionListener());
            popupMenu.add(this.m_removeRuleMenuItem);
            popupMenu.add(new JSeparator());
            this.m_addPropertyMenuItem = new JMenuItem("Add Rule Property");
            this.m_addPropertyMenuItem.addActionListener(new AddRulePropertyActionListener());
            popupMenu.add(this.m_addPropertyMenuItem);
            this.m_removePropertyMenuItem = new JMenuItem("Remove Rule Property");
            this.m_removePropertyMenuItem.addActionListener(new RemoveRulePropertyActionListener());
            popupMenu.add(this.m_removePropertyMenuItem);
            if (addInclude) {
                popupMenu.add(new JSeparator());
                this.m_includeMenuItem = new JCheckBoxMenuItem("Include");
                this.m_includeMenuItem.addActionListener(new IncludeActionListener());
                this.m_includeMenuItem.setSelected(RulesTree.this.getSelectedNode().include());
                popupMenu.add(this.m_includeMenuItem);
            }
            return popupMenu;
        }
    }
}

