/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.swingui.Constants;
import net.sourceforge.pmd.swingui.event.RulesTreeModelEvent;

public class RulesTreeNode
extends DefaultMutableTreeNode
implements Constants {
    private RuleSet m_ruleSet;
    private Rule m_rule;
    private String m_className;
    private String m_name;
    private String m_message;
    private String m_description;
    private String m_example;
    private String m_propertyValue;
    private String m_propertyValueType;
    private int m_type;
    private boolean m_include;
    private int m_priority;
    private static final int IS_ROOT = 1;
    private static final int IS_RULE_SET = 2;
    private static final int IS_RULE = 4;
    private static final int IS_PROPERTY = 8;

    protected RulesTreeNode(String text) {
        this.m_name = this.trim(text);
        this.m_type = 1;
        this.m_include = true;
        this.setDisplayName();
    }

    protected RulesTreeNode(RuleSet ruleSet) {
        this.m_name = this.trim(ruleSet.getName());
        this.m_description = this.trim(ruleSet.getDescription());
        this.m_ruleSet = ruleSet;
        this.m_type = 2;
        this.m_include = ruleSet.include();
        this.setDisplayName();
    }

    protected RulesTreeNode(RulesTreeNode ruleSetNode, Rule rule) {
        this.m_name = this.trim(rule.getName());
        this.m_className = this.trim(rule.getClass().getName());
        this.m_message = this.trim(rule.getMessage());
        this.m_description = this.trim(rule.getDescription());
        this.m_example = this.trim(rule.getExample());
        this.m_ruleSet = ruleSetNode.getRuleSet();
        this.m_rule = rule;
        this.m_type = 4;
        this.m_include = rule.include();
        this.m_priority = rule.getPriority();
        this.setDisplayName();
    }

    protected RulesTreeNode(RulesTreeNode ruleNode, String propertyName, String propertyValue, String propertyValueType) {
        this.m_name = this.trim(propertyName);
        this.m_propertyValue = this.trim(propertyValue);
        this.m_propertyValueType = this.trim(propertyValueType);
        this.m_type = 8;
        this.m_rule = ruleNode.getRule();
        this.m_ruleSet = ((RulesTreeNode)ruleNode.getParent()).getRuleSet();
        this.m_include = true;
        this.setDisplayName();
    }

    protected RulesTreeNode getChildNode(String childName) {
        Enumeration<TreeNode> children = this.children();
        while (children.hasMoreElements()) {
            RulesTreeNode childNode = (RulesTreeNode)children.nextElement();
            if (!childNode.getName().equalsIgnoreCase(childName)) continue;
            return childNode;
        }
        return null;
    }

    protected String getClassName() {
        return this.m_className;
    }

    protected String getDescription() {
        return this.m_description;
    }

    protected String getExample() {
        return this.m_example;
    }

    protected String getMessage() {
        return this.m_message;
    }

    protected String getName() {
        return this.m_name;
    }

    protected RulesTreeNode getParentRuleData() {
        if (this.isProperty()) {
            return (RulesTreeNode)this.getParent();
        }
        return null;
    }

    protected RulesTreeNode getParentRuleSetData() {
        if (this.isProperty()) {
            return (RulesTreeNode)this.getParent().getParent();
        }
        if (this.isRule()) {
            return (RulesTreeNode)this.getParent();
        }
        return null;
    }

    protected String getPropertyValue() {
        return this.m_propertyValue;
    }

    protected String getPropertyValueType() {
        return this.m_propertyValueType;
    }

    protected RulesTreeNode getSibling(String name) {
        RulesTreeNode parentNode = (RulesTreeNode)this.getParent();
        if (parentNode != null) {
            return parentNode.getChildNode(name);
        }
        return null;
    }

    protected boolean include() {
        return this.m_include;
    }

    protected boolean includeAncestor() {
        boolean include = true;
        if (include) {
            RulesTreeNode ruleNode;
            if (this.isRule()) {
                RulesTreeNode ruleSetNode = (RulesTreeNode)this.getParent();
                include = ruleSetNode.include();
            } else if (this.isProperty() && (ruleNode = (RulesTreeNode)this.getParent()).include()) {
                RulesTreeNode ruleSetNode = (RulesTreeNode)ruleNode.getParent();
                include = ruleSetNode.include();
            }
        }
        return include;
    }

    protected boolean isProperty() {
        return this.m_type == 8;
    }

    protected boolean isRule() {
        return this.m_type == 4;
    }

    protected boolean isRuleSet() {
        return this.m_type == 2;
    }

    public boolean isRoot() {
        return this.m_type == 1;
    }

    protected Rule getRule() {
        return this.m_rule;
    }

    protected RuleSet getRuleSet() {
        return this.m_ruleSet;
    }

    protected int getPriority() {
        return this.m_priority;
    }

    protected void setDisplayName() {
        String displayName = this.isProperty() ? this.m_name + ":" + this.m_propertyValue : this.m_name;
        this.setUserObject(displayName);
    }

    protected void setName(String newName) {
        this.m_name = this.trim(newName);
        this.setDisplayName();
    }

    protected void setMessage(String newMessage) {
        this.m_message = this.trim(newMessage);
    }

    protected void setDescription(String newDescription) {
        this.m_description = this.trim(newDescription);
    }

    protected void setExample(String newExample) {
    }

    protected void setPropertyValue(String newValue) {
        this.m_propertyValue = this.trim(newValue);
        this.setDisplayName();
    }

    protected void setPropertyValueType(String newValue) {
        this.m_propertyValueType = this.trim(newValue);
    }

    protected void setInclude(boolean include) {
        this.m_include = include;
    }

    protected void setPriority(int priority) {
        this.m_priority = priority;
    }

    protected void setClassName(String newClassName) {
        this.m_className = this.trim(newClassName);
    }

    protected void saveData() {
        if (this.isRuleSet()) {
            this.m_ruleSet.setName(this.m_name);
            this.m_ruleSet.setDescription(this.m_description);
            this.m_ruleSet.setInclude(this.m_include);
        } else if (this.isRule()) {
            this.m_rule.setName(this.m_name);
            this.m_rule.setMessage(this.m_message);
            this.m_rule.setDescription(this.m_description);
            this.m_rule.setExample(this.m_example);
            this.m_rule.setInclude(this.m_include);
            this.m_rule.setPriority(this.m_priority);
        } else if (this.isProperty()) {
            this.m_rule.getProperties().setValue(this.m_name, this.m_propertyValue);
            this.m_rule.getProperties().setValueType(this.m_name, this.m_propertyValueType);
        }
    }

    private String trim(String text) {
        if (text == null) {
            text = "";
        } else if ((text = text.trim()).length() == 0) {
            text = "";
        }
        return text;
    }

    protected void sortChildren() {
        int childCount = this.getChildCount();
        RulesTreeNode[] treeNodes = new RulesTreeNode[childCount];
        boolean needToSort = false;
        int n = 0;
        while (n < childCount) {
            treeNodes[n] = (RulesTreeNode)this.getChildAt(n);
            if (n > 0 && !needToSort) {
                String previousNodeName = treeNodes[n - 1].getName();
                String currentNodeName = treeNodes[n].getName();
                if (currentNodeName.compareToIgnoreCase(previousNodeName) < 0) {
                    needToSort = true;
                }
            }
            ++n;
        }
        if (needToSort) {
            Arrays.sort(treeNodes, new SortComparator());
            this.removeAllChildren();
            int n2 = 0;
            while (n2 < treeNodes.length) {
                this.add(treeNodes[n2]);
                ++n2;
            }
            RulesTreeModelEvent.notifyReload(this, this);
        }
        int n3 = 0;
        while (n3 < treeNodes.length) {
            treeNodes[n3] = null;
            ++n3;
        }
    }

    private class SortComparator
    implements Comparator {
        private SortComparator() {
        }

        public int compare(Object object1, Object object2) {
            String name1 = ((RulesTreeNode)object1).getName();
            String name2 = ((RulesTreeNode)object2).getName();
            return name1.compareToIgnoreCase(name2);
        }

        public boolean equals(Object object) {
            return object == this;
        }
    }
}

