/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.symboltable;

import net.sourceforge.pmd.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.Scope;

public class NameOccurrence {
    private SimpleNode location;
    private String image;
    private NameOccurrence qualifiedName;
    private boolean isMethodOrConstructorInvocation;

    public NameOccurrence(SimpleNode location, String image) {
        this.location = location;
        this.image = image;
    }

    public void setIsMethodOrConstructorInvocation() {
        this.isMethodOrConstructorInvocation = true;
    }

    public boolean isMethodOrConstructorInvocation() {
        return this.isMethodOrConstructorInvocation;
    }

    public void setNameWhichThisQualifies(NameOccurrence qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public NameOccurrence getNameForWhichThisIsAQualifier() {
        return this.qualifiedName;
    }

    public SimpleNode getLocation() {
        return this.location;
    }

    public boolean isOnLeftHandSide() {
        SimpleNode primaryExpression;
        if (this.location.jjtGetParent() instanceof ASTPrimaryExpression) {
            primaryExpression = (SimpleNode)this.location.jjtGetParent().jjtGetParent();
        } else if (this.location.jjtGetParent().jjtGetParent() instanceof ASTPrimaryExpression) {
            primaryExpression = (SimpleNode)this.location.jjtGetParent().jjtGetParent().jjtGetParent();
        } else {
            throw new RuntimeException("Found a NameOccurrence that didn't have an ASTPrimary Expression as parent or grandparent.  Parent = " + this.location.jjtGetParent() + " and grandparent = " + this.location.jjtGetParent().jjtGetParent());
        }
        return primaryExpression.jjtGetNumChildren() > 1 && primaryExpression.jjtGetChild(1) instanceof ASTAssignmentOperator;
    }

    public Scope getScope() {
        return this.location.getScope();
    }

    public int getBeginLine() {
        return this.location.getBeginLine();
    }

    public boolean isThisOrSuper() {
        return this.image.equals("this") || this.image.equals("super");
    }

    public boolean equals(Object o) {
        NameOccurrence n = (NameOccurrence)o;
        return n.getImage().equals(this.getImage());
    }

    public String getImage() {
        return this.image;
    }

    public int hashCode() {
        return this.getImage().hashCode();
    }

    public String toString() {
        return this.getImage() + ":" + this.location.getBeginLine() + ":" + this.location.getClass();
    }
}

