/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.cpd;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sourceforge.pmd.cpd.CPDListener;
import net.sourceforge.pmd.cpd.CPDNullListener;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.MarkComparator;
import net.sourceforge.pmd.cpd.TokenEntry;

public class MarkComparatorTest
extends TestCase {
    private boolean gotCallback;

    public void testEqualMarksAreEqual() {
        List code = this.getCode();
        MarkComparator comp = new MarkComparator(new CPDNullListener(), code);
        Mark mark1 = new Mark(code.size(), "/var/Foo.java", 0, 1);
        Mark mark6 = new Mark(code.size(), "/var/Foo.java", 5, 1);
        Assert.assertEquals((int)0, (int)comp.compare(mark1, mark6));
    }

    public void testSameMarkIsEqual() {
        List code = this.getCode();
        MarkComparator comp = new MarkComparator(new CPDNullListener(), code);
        Mark mark1 = new Mark(code.size(), "/var/Foo.java", 0, 1);
        Assert.assertEquals((int)0, (int)comp.compare(mark1, mark1));
    }

    public void testUnuequalMarksAreUnequal() {
        Mark mark5;
        Mark mark1;
        List code = this.getCode();
        MarkComparator comp = new MarkComparator(new CPDNullListener(), code);
        Assert.assertFalse((0 == comp.compare(mark1 = new Mark(0, "/var/Foo.java", 0, 1), mark5 = new Mark(4, "/var/Foo.java", 4, 1)) ? 1 : 0) != 0);
    }

    public void testcomparisonCountCallback() {
        this.gotCallback = false;
        List code = this.getCode();
        MarkComparator comp = new MarkComparator(new MyListener(), code, 3);
        Mark mark1 = new Mark(code.size(), "/var/Foo.java", 0, 1);
        Mark mark2 = new Mark(code.size(), "/var/Foo.java", 1, 1);
        comp.compare(mark1, mark2);
        comp.compare(mark1, mark2);
        comp.compare(mark1, mark2);
        Assert.assertTrue((boolean)this.gotCallback);
    }

    public void test1() {
    }

    private List getCode() {
        ArrayList<TokenEntry> code = new ArrayList<TokenEntry>();
        TokenEntry te1 = new TokenEntry("System", 0, "/var/Foo.java", 1);
        TokenEntry te2 = new TokenEntry(".", 1, "/var/Foo.java", 1);
        TokenEntry te3 = new TokenEntry("out", 2, "/var/Foo.java", 1);
        TokenEntry te4 = new TokenEntry(".", 3, "/var/Foo.java", 1);
        TokenEntry te5 = new TokenEntry("println", 4, "/var/Foo.java", 1);
        TokenEntry te6 = new TokenEntry("System", 5, "/var/Foo.java", 1);
        code.add(te1);
        code.add(te2);
        code.add(te3);
        code.add(te4);
        code.add(te5);
        code.add(te6);
        return code;
    }

    private class MyListener
    implements CPDListener {
        private MyListener() {
        }

        public void addedFile(int fileCount, File file) {
        }

        public void comparisonCountUpdate(long comparisons) {
            MarkComparatorTest.this.gotCallback = true;
        }
    }
}

