/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.cpd;

import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;

public class MatchTest
extends TestCase {
    public void testSimple() {
        Mark mark1 = new Mark(1, "/var/Foo.java", 1, 1);
        Mark mark2 = new Mark(2, "/var/Foo.java", 2, 1);
        Match match = new Match(1, mark1, mark2);
        match.setSourceCodeSlice("public class Foo {}");
        Assert.assertEquals((String)"public class Foo {}", (String)match.getSourceCodeSlice());
        match.setLineCount(10);
        Assert.assertEquals((int)10, (int)match.getLineCount());
        Assert.assertEquals((int)1, (int)match.getTokenCount());
        Iterator i = match.iterator();
        Assert.assertEquals((Object)mark1, i.next());
        Assert.assertEquals((Object)mark2, i.next());
        Assert.assertFalse((boolean)i.hasNext());
    }

    public void testCompareTo() {
        Match m2 = new Match(2, new Mark(4, "/var/Foo.java", 4, 1), new Mark(5, "/var/Foo.java", 5, 1));
        Match m1 = new Match(1, new Mark(1, "/var/Foo.java", 1, 1), new Mark(2, "/var/Foo.java", 2, 1));
        Assert.assertTrue((m2.compareTo(m1) < 0 ? 1 : 0) != 0);
    }
}

