/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.jaxen;

import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTImportDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.ast.ASTStatement;
import net.sourceforge.pmd.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.jaxen.DocumentNavigator;
import org.jaxen.BaseXPath;
import org.jaxen.JaxenException;
import org.jaxen.Navigator;
import org.jaxen.UnsupportedAxisException;
import test.net.sourceforge.pmd.rules.EmptyCatchBlockRuleTest;
import test.net.sourceforge.pmd.rules.RuleTst;

public class DocumentNavigatorTest
extends RuleTst {
    private TestRule rule;

    public void setUp() throws Exception {
        try {
            this.rule = new TestRule();
            this.runTestFromString(EmptyCatchBlockRuleTest.TEST1, this.rule, new Report());
        }
        catch (Throwable xx) {
            Assert.fail();
        }
    }

    public void testChildAxisIterator() {
        DocumentNavigator nav = new DocumentNavigator();
        Iterator iter = nav.getChildAxisIterator(this.rule.compilationUnit);
        Assert.assertSame((Object)this.rule.compilationUnit.jjtGetChild(0), iter.next());
        Assert.assertSame((Object)this.rule.compilationUnit.jjtGetChild(1), iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    public void testParentAxisIterator() {
        DocumentNavigator nav = new DocumentNavigator();
        Iterator iter = nav.getParentAxisIterator(this.rule.importDeclaration);
        Assert.assertSame((Object)this.rule.importDeclaration.jjtGetParent(), iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    public void testParentAxisIterator2() {
        DocumentNavigator nav = new DocumentNavigator();
        Iterator iter = nav.getParentAxisIterator(this.rule.compilationUnit);
        Assert.assertFalse((boolean)iter.hasNext());
    }

    public void testDescendantAxisIterator() throws UnsupportedAxisException {
        DocumentNavigator nav = new DocumentNavigator();
        Iterator iter = nav.getDescendantAxisIterator(this.rule.statement);
        Node statementExpression = this.rule.statement.jjtGetChild(0);
        Assert.assertSame((Object)statementExpression, iter.next());
        Node primaryExpression = statementExpression.jjtGetChild(0);
        Assert.assertSame((Object)primaryExpression, iter.next());
        Node primaryPrefix = primaryExpression.jjtGetChild(0);
        Assert.assertSame((Object)primaryPrefix, iter.next());
        Node primarySuffix = primaryExpression.jjtGetChild(1);
        Assert.assertSame((Object)primarySuffix, iter.next());
        Node name = primaryPrefix.jjtGetChild(0);
        Assert.assertSame((Object)name, iter.next());
        Node arguments = primarySuffix.jjtGetChild(0);
        Assert.assertSame((Object)arguments, iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    public void testDescendantAxisIterator2() throws UnsupportedAxisException {
        DocumentNavigator nav = new DocumentNavigator();
        Iterator iter = nav.getDescendantAxisIterator(this.rule.primaryPrefix);
        Node name = this.rule.primaryPrefix.jjtGetChild(0);
        Assert.assertSame((Object)name, iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    public void testFollowingSiblingAxisIterator() {
        DocumentNavigator nav = new DocumentNavigator();
        Iterator iter = nav.getFollowingSiblingAxisIterator(this.rule.primaryExpression.jjtGetChild(0));
        Assert.assertSame((Object)this.rule.primaryExpression.jjtGetChild(1), iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    public void testFollowingSiblingAxisIterator2() {
        DocumentNavigator nav = new DocumentNavigator();
        Iterator iter = nav.getFollowingSiblingAxisIterator(this.rule.primaryExpression.jjtGetChild(1));
        Assert.assertFalse((boolean)iter.hasNext());
    }

    public void testPrecedingSiblingAxisIterator() {
        DocumentNavigator nav = new DocumentNavigator();
        Iterator iter = nav.getPrecedingSiblingAxisIterator(this.rule.primaryExpression.jjtGetChild(1));
        Assert.assertSame((Object)this.rule.primaryExpression.jjtGetChild(0), iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    public void testPrecedingSiblingAxisIterator2() {
        DocumentNavigator nav = new DocumentNavigator();
        Iterator iter = nav.getPrecedingSiblingAxisIterator(this.rule.primaryExpression.jjtGetChild(0));
        Assert.assertFalse((boolean)iter.hasNext());
    }

    public void testXPath() throws JaxenException {
        BaseXPath xPath = new BaseXPath(".//*", (Navigator)new DocumentNavigator());
        List matches = xPath.selectNodes((Object)this.rule.statement);
        Assert.assertEquals((int)6, (int)matches.size());
    }

    public void testXPath2() throws JaxenException {
        BaseXPath xPath = new BaseXPath(".//*", (Navigator)new DocumentNavigator());
        List matches = xPath.selectNodes((Object)this.rule.importDeclaration);
        Assert.assertEquals((int)1, (int)matches.size());
    }

    public void testXPath3() throws JaxenException {
        BaseXPath xPath = new BaseXPath(".//*", (Navigator)new DocumentNavigator());
        List matches = xPath.selectNodes((Object)this.rule.typeDeclaration);
        Assert.assertEquals((int)76, (int)matches.size());
    }

    public void testXPath4() throws JaxenException {
        BaseXPath xPath = new BaseXPath(".//*", (Navigator)new DocumentNavigator());
        List matches = xPath.selectNodes((Object)this.rule.compilationUnit);
        Assert.assertEquals((int)79, (int)matches.size());
    }

    private class TestRule
    extends AbstractRule {
        private Node compilationUnit;
        private Node importDeclaration;
        private Node typeDeclaration;
        private Node statement;
        private Node primaryPrefix;
        private Node primaryExpression;
        private Node methodDeclaration;

        private TestRule() {
        }

        public Object visit(ASTCompilationUnit node, Object data) {
            this.compilationUnit = node;
            return super.visit(node, data);
        }

        public Object visit(ASTImportDeclaration node, Object data) {
            this.importDeclaration = node;
            return super.visit(node, data);
        }

        public Object visit(ASTTypeDeclaration node, Object data) {
            this.typeDeclaration = node;
            return super.visit(node, data);
        }

        public Object visit(ASTStatement node, Object data) {
            this.statement = node;
            return super.visit(node, data);
        }

        public Object visit(ASTPrimaryPrefix node, Object data) {
            this.primaryPrefix = node;
            return super.visit(node, data);
        }

        public Object visit(ASTMethodDeclaration node, Object data) {
            this.methodDeclaration = node;
            return super.visit(node, data);
        }

        public Object visit(ASTPrimaryExpression node, Object data) {
            this.primaryExpression = node;
            return super.visit(node, data);
        }
    }
}

