/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.symboltable;

import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.AbstractScope;
import net.sourceforge.pmd.symboltable.NameDeclaration;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.symboltable.Scope;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;

public class AbstractScopeTest
extends TestCase {
    public void testAccessors() {
        MyScope scope = new MyScope();
        MyScope parent = new MyScope();
        scope.setParent(parent);
        Assert.assertEquals((Object)parent, (Object)scope.getParent());
        Assert.assertTrue((!scope.getVariableDeclarations(false).keySet().iterator().hasNext() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)scope.getVariableDeclarations(true).isEmpty());
    }

    public void testEnclClassScopeGetsDelegatedRight() {
        MyScope scope = new MyScope();
        IsEnclosingClassScope isEncl = new IsEnclosingClassScope();
        scope.setParent(isEncl);
        Assert.assertEquals((Object)isEncl, (Object)scope.getEnclosingClassScope());
    }

    public void testAdd() {
        MyScope scope = new MyScope();
        ASTVariableDeclaratorId node = new ASTVariableDeclaratorId(1);
        node.setImage("foo");
        VariableNameDeclaration decl = new VariableNameDeclaration(node);
        scope.addDeclaration(decl);
        Assert.assertTrue((boolean)scope.contains(new NameOccurrence(new SimpleNode(1), "foo")));
    }

    private class IsEnclosingClassScope
    extends AbstractScope {
        private IsEnclosingClassScope() {
        }

        protected NameDeclaration findVariableHere(NameOccurrence occ) {
            return null;
        }

        public Scope getEnclosingClassScope() {
            return this;
        }
    }

    private class MyScope
    extends AbstractScope {
        private MyScope() {
        }

        protected NameDeclaration findVariableHere(NameOccurrence occ) {
            Iterator i = this.variableNames.keySet().iterator();
            while (i.hasNext()) {
                NameDeclaration decl = (NameDeclaration)i.next();
                if (!decl.getImage().equals(occ.getImage())) continue;
                return decl;
            }
            return null;
        }
    }
}

