/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.util;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.BitSet;
import java.util.StringTokenizer;

public class FileUtil {
    static BitSet safeChars = new BitSet(256);

    public static final String sanitizeFileName(String name) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if ((c != '.' || i >= name.length() - 1 || name.charAt(i + 1) != '.') && safeChars.get(c)) {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public static final String pickSafeFileName(URL url) {
        String name = FileUtil.sanitizeFileName(new File(url.getFile()).getName());
        if (name == null || name.equals("")) {
            name = "index.html";
        }
        return name;
    }

    public static File safeOnionFile(String rel) {
        if (new File(rel).isAbsolute()) {
            throw new IllegalArgumentException(rel + " isn't relative");
        }
        StringBuffer safe = new StringBuffer();
        StringTokenizer st = new StringTokenizer(rel, File.separator);
        while (st.hasMoreTokens()) {
            String tok = FileUtil.sanitizeFileName(st.nextToken());
            if (tok == null || "".equals(tok)) {
                throw new IllegalArgumentException("collapsed elemnt");
            }
            if (safe == null) {
                safe = new StringBuffer(tok);
                continue;
            }
            safe.append(File.separator).append(tok);
        }
        File result = new File(FileUtil.getOnionDir(), safe.toString());
        try {
            FileUtil.ensureExists(result);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to ensure that file exists: " + e.getMessage());
        }
        return result;
    }

    public static void ensureExists(File f) throws IOException {
        if (!f.getParentFile().exists() && !f.getParentFile().mkdirs()) {
            throw new IOException("Couldn't create parent dirs: " + f);
        }
        if (!f.exists()) {
            f.createNewFile();
        }
    }

    public static File getOnionDir() {
        String s = System.getProperty("user.home");
        if (s == null) {
            return null;
        }
        File f = new File(s, ".onion");
        if (!f.exists() && !f.mkdirs()) {
            return null;
        }
        return f;
    }

    public static final File getUserTempDir() {
        File f = new File(FileUtil.getOnionDir(), "tmp");
        if (!f.exists() && !f.mkdirs()) {
            return null;
        }
        return f;
    }

    public static final File createTempFile(File f) throws IOException {
        String name;
        File parent;
        if (f == null) {
            parent = FileUtil.getUserTempDir();
            String string = "onion";
        } else {
            parent = f.getAbsoluteFile().getParentFile();
            name = f.getName();
            if (name.length() < 3) {
                name = name + "onion";
            }
        }
        try {
            return File.createTempFile(name, null, parent);
        }
        catch (IOException e) {
            if (f != null) {
                return FileUtil.createTempFile(null);
            }
            if (parent != null) {
                return File.createTempFile(name, null, null);
            }
            throw new IOException("Unable to create temp file");
        }
    }

    public static void skipFully(InputStream is, long count) throws IOException {
        byte[] b = null;
        long left = count;
        while (left > 0L) {
            long skipped = is.skip(left);
            if (skipped == 0L) {
                int c;
                if (b == null) {
                    b = new byte[1024];
                }
                if ((c = is.read(b, 0, (int)Math.min((long)b.length, left))) == -1) {
                    throw new EOFException();
                }
                skipped = c;
            }
            left -= skipped;
        }
    }

    static {
        int i = 97;
        while (i <= 122) {
            safeChars.set(i);
            ++i;
        }
        i = 65;
        while (i <= 90) {
            safeChars.set(i);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            safeChars.set(i);
            ++i;
        }
        safeChars.set(45);
        safeChars.set(95);
        safeChars.set(32);
        safeChars.set(46);
    }
}

