/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.ContentDescription;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.util.Utils;

public class ContentDescriptionReader {
    public static ContentDescription read(RandomAccessFile raf, Chunk candidate) throws IOException {
        if (raf == null || candidate == null) {
            throw new IllegalArgumentException("Arguments must not be null.");
        }
        if (GUID.GUID_CONTENTDESCRIPTION.equals(candidate.getGuid())) {
            raf.seek(candidate.getPosition());
            return new ContentDescriptionReader().parseData(raf);
        }
        return null;
    }

    public static String readFixedSizeUTF16Str(RandomAccessFile raf, int strLen) throws IOException {
        byte[] strBytes = new byte[strLen];
        int read = raf.read(strBytes);
        if (read == strBytes.length) {
            if (strBytes.length >= 2 && strBytes[strBytes.length - 1] == 0 && strBytes[strBytes.length - 2] == 0) {
                byte[] copy = new byte[strBytes.length - 2];
                System.arraycopy(strBytes, 0, copy, 0, strBytes.length - 2);
                strBytes = copy;
            }
            return new String(strBytes, "UTF-16LE");
        }
        throw new IllegalStateException("Couldn't read the necessary amount of bytes.");
    }

    protected ContentDescriptionReader() {
    }

    private int[] getStringSizes(RandomAccessFile raf) throws IOException {
        int[] result = new int[5];
        int i = 0;
        while (i < result.length) {
            result[i] = Utils.readUINT16(raf);
            ++i;
        }
        return result;
    }

    private ContentDescription parseData(RandomAccessFile raf) throws IOException {
        ContentDescription result = null;
        long chunkStart = raf.getFilePointer();
        GUID guid = Utils.readGUID(raf);
        if (GUID.GUID_CONTENTDESCRIPTION.equals(guid)) {
            BigInteger chunkLen = Utils.readBig64(raf);
            result = new ContentDescription(chunkStart, chunkLen);
            int[] stringSizes = this.getStringSizes(raf);
            String[] strings = new String[stringSizes.length];
            int i = 0;
            while (i < strings.length) {
                if (stringSizes[i] > 0) {
                    strings[i] = ContentDescriptionReader.readFixedSizeUTF16Str(raf, stringSizes[i]);
                }
                ++i;
            }
            if (stringSizes[0] > 0) {
                result.setTitle(strings[0]);
            }
            if (stringSizes[1] > 0) {
                result.setAuthor(strings[1]);
            }
            if (stringSizes[2] > 0) {
                result.setCopyRight(strings[2]);
            }
            if (stringSizes[3] > 0) {
                result.setComment(strings[3]);
            }
            if (stringSizes[4] > 0) {
                result.setRating(strings[4]);
            }
        }
        return result;
    }
}

