/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.shortestpath;

import edu.uci.ics.jung.algorithms.connectivity.BFSDistanceLabeler;
import edu.uci.ics.jung.algorithms.shortestpath.Distance;
import edu.uci.ics.jung.algorithms.shortestpath.ShortestPath;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.UserDataUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UnweightedShortestPath
implements ShortestPath,
Distance {
    private Map mDistanceMap;
    private Map mIncomingEdgeMap;
    private Graph mGraph;

    public UnweightedShortestPath(Graph g) {
        this.mDistanceMap = new HashMap(g.numVertices() * 2);
        this.mIncomingEdgeMap = new HashMap(g.numVertices() * 2);
        this.mGraph = g;
    }

    public Number getDistance(ArchetypeVertex source, ArchetypeVertex target) {
        Map sourceSPMap = this.getDistanceMap(source);
        return (Number)sourceSPMap.get(target);
    }

    public Map getDistanceMap(ArchetypeVertex source) {
        Map sourceSPMap = (Map)this.mDistanceMap.get(source);
        if (sourceSPMap == null) {
            this.computeShortestPathsFromSource(source);
            sourceSPMap = (Map)this.mDistanceMap.get(source);
        }
        return sourceSPMap;
    }

    public Map getIncomingEdgeMap(Vertex source) {
        Map sourceIEMap = (Map)this.mIncomingEdgeMap.get(source);
        if (sourceIEMap == null) {
            this.computeShortestPathsFromSource(source);
            sourceIEMap = (Map)this.mIncomingEdgeMap.get(source);
        }
        return sourceIEMap;
    }

    public int getShortestPath(Vertex source, Vertex target) {
        return this.getDistance(source, target).intValue();
    }

    private void computeShortestPathsFromSource(ArchetypeVertex source) {
        String DISTANCE_KEY = "UnweightedShortestPath.DISTANCE";
        BFSDistanceLabeler labeler = new BFSDistanceLabeler(DISTANCE_KEY);
        labeler.labelDistances(this.mGraph, (Vertex)source);
        HashMap<Vertex, Number> currentSourceSPMap = new HashMap<Vertex, Number>();
        HashMap<Vertex, Edge> currentSourceEdgeMap = new HashMap<Vertex, Edge>();
        Iterator vIt = this.mGraph.getVertices().iterator();
        while (vIt.hasNext()) {
            Vertex vertex = (Vertex)vIt.next();
            Number distanceVal = (Number)vertex.getUserDatum(DISTANCE_KEY);
            if (distanceVal == null || distanceVal.intValue() < 0) continue;
            currentSourceSPMap.put(vertex, distanceVal);
            int minDistance = distanceVal.intValue();
            Iterator eIt = vertex.getInEdges().iterator();
            while (eIt.hasNext()) {
                Edge incomingEdge = (Edge)eIt.next();
                Vertex neighbor = incomingEdge.getOpposite(vertex);
                Number predDistanceVal = (Number)neighbor.getUserDatum(DISTANCE_KEY);
                int pred_distance = predDistanceVal.intValue();
                if (pred_distance >= minDistance || pred_distance < 0) continue;
                minDistance = predDistanceVal.intValue();
                currentSourceEdgeMap.put(vertex, incomingEdge);
            }
        }
        UserDataUtils.cleanup(this.mGraph.getVertices(), DISTANCE_KEY);
        this.mDistanceMap.put(source, currentSourceSPMap);
        this.mIncomingEdgeMap.put(source, currentSourceEdgeMap);
    }

    public void reset() {
        this.mDistanceMap = new HashMap(this.mGraph.numVertices() * 2);
        this.mIncomingEdgeMap = new HashMap(this.mGraph.numVertices() * 2);
    }

    public void reset(Vertex v) {
        this.mDistanceMap.put(v, null);
        this.mIncomingEdgeMap.put(v, null);
    }
}

