/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.filters.impl;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.decorators.EdgeWeightLabeller;
import edu.uci.ics.jung.graph.filters.EfficientFilter;
import edu.uci.ics.jung.graph.filters.GeneralEdgeAcceptFilter;
import edu.uci.ics.jung.graph.filters.LevelFilter;

public class WeightedEdgeGraphFilter
extends GeneralEdgeAcceptFilter
implements LevelFilter,
EfficientFilter {
    private int threshold;
    private EdgeWeightLabeller labels;

    public WeightedEdgeGraphFilter(int threshold, EdgeWeightLabeller el) {
        this.setValue(threshold);
        this.labels = el;
    }

    public String getName() {
        return "WeightedGraph(" + this.threshold + ")";
    }

    public void setValue(int threshold) {
        this.threshold = threshold;
    }

    public int getValue() {
        return this.threshold;
    }

    public boolean acceptEdge(Edge e) {
        Edge edge = (Edge)e.getEqualEdge(this.labels.getGraph());
        int val = this.labels.getWeight(edge);
        if (val < this.threshold) {
            // empty if block
        }
        return val >= this.threshold;
    }
}

