/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.predicates;

import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.predicates.EdgePredicate;

public class UserDatumEdgePredicate
extends EdgePredicate {
    public static final String message = "UserDatumEdgePredicate: ";
    private Object datum;
    private Object key;

    public UserDatumEdgePredicate(Object key, Object datum) {
        if (key == null) {
            throw new IllegalArgumentException("UserDatumEdgePredicate key must be non-null");
        }
        this.datum = datum;
        this.key = key;
    }

    public boolean evaluateEdge(ArchetypeEdge e) {
        Object value = e.getUserDatum(this.key);
        return this.datum == null && value == null || this.datum.equals(value);
    }

    public String toString() {
        return "UserDatumEdgePredicate: (" + this.key + ", " + this.datum + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof UserDatumEdgePredicate)) {
            return false;
        }
        UserDatumEdgePredicate udep = (UserDatumEdgePredicate)o;
        return udep.datum.equals(this.datum) && udep.key.equals(this.key);
    }

    public int hashCode() {
        return this.datum.hashCode() + this.key.hashCode();
    }

    public Object getKey() {
        return this.key;
    }

    public Object getDatum() {
        return this.datum;
    }
}

