/*
 * Decompiled with CFR 0.152.
 */
package samples.graph;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.Indexer;
import edu.uci.ics.jung.graph.decorators.StringLabeller;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.graph.impl.SparseVertex;
import edu.uci.ics.jung.visualization.FRLayout;
import edu.uci.ics.jung.visualization.LayoutMutable;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.ShapePickSupport;
import edu.uci.ics.jung.visualization.SpringLayout;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JRootPane;

public class AddNodeDemo
extends JApplet {
    private Graph g = null;
    private VisualizationViewer vv = null;
    private LayoutMutable layout = null;
    private StringLabeller labler = null;
    Timer timer;
    protected JButton switchLayout;
    public static final SpringLayout.LengthFunction UNITLENGTHFUNCTION = new SpringLayout.UnitLengthFunction(100);
    Vertex v_prev = null;

    public void init() {
        this.g = new DirectedSparseGraph();
        this.layout = new FRLayout(this.g);
        this.vv = new VisualizationViewer(this.layout, (Renderer)new PluggableRenderer());
        JRootPane rp = this.getRootPane();
        rp.putClientProperty("defeatSystemEventQueueCheck", Boolean.TRUE);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().setBackground(Color.lightGray);
        this.getContentPane().setFont(new Font("Serif", 0, 12));
        this.vv.getModel().setRelaxerThreadSleepTime(500L);
        this.vv.setPickSupport(new ShapePickSupport());
        this.vv.setGraphMouse(new DefaultModalGraphMouse());
        this.getContentPane().add(this.vv);
        this.switchLayout = new JButton("Switch to SpringLayout");
        this.switchLayout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AddNodeDemo.this.switchLayout.getText().indexOf("Spring") > 0) {
                    AddNodeDemo.this.switchLayout.setText("Switch to FRLayout");
                    AddNodeDemo.this.layout = new SpringLayout(AddNodeDemo.this.g, UNITLENGTHFUNCTION);
                    AddNodeDemo.this.vv.getModel().setGraphLayout(AddNodeDemo.this.layout);
                } else {
                    AddNodeDemo.this.switchLayout.setText("Switch to SpringLayout");
                    AddNodeDemo.this.layout = new FRLayout(AddNodeDemo.this.g);
                    AddNodeDemo.this.vv.getModel().setGraphLayout(AddNodeDemo.this.layout);
                }
                if (!AddNodeDemo.this.vv.isVisRunnerRunning()) {
                    AddNodeDemo.this.vv.init();
                }
            }
        });
        this.getContentPane().add((Component)this.switchLayout, "South");
        this.labler = StringLabeller.getLabeller(this.g);
        this.timer = new Timer();
    }

    public void start() {
        this.validate();
        this.timer.schedule((TimerTask)new RemindTask(), 1000L, 1000L);
        this.vv.repaint();
    }

    public void process() {
        System.out.println("-[----------------------------");
        int label_number = 0;
        boolean redraw = false;
        redraw = true;
        try {
            int vertices = 0;
            if (vertices < 100) {
                redraw = true;
                ++vertices;
                label_number = (int)(Math.random() * 10000.0);
                long eid = (int)(Math.random() * 10000.0);
                System.out.println("P: adding a node " + label_number);
                Vertex v1 = this.g.addVertex(new SparseVertex());
                if (this.v_prev != null) {
                    this.g.addEdge(new DirectedSparseEdge(this.v_prev, v1));
                    Indexer i = Indexer.getAndUpdateIndexer(this.g);
                    int rand = (int)(Math.random() * (double)this.g.numVertices());
                    Vertex v_rand = (Vertex)i.getVertex(rand);
                    this.g.addEdge(new DirectedSparseEdge(v1, v_rand));
                }
                this.v_prev = v1;
                this.labler.setLabel(v1, "" + eid);
            }
            if (redraw) {
                System.out.println("P: Updating");
                this.layout.update();
                if (!this.vv.isVisRunnerRunning()) {
                    this.vv.init();
                }
                this.vv.repaint();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        System.out.println("------------end process------------");
    }

    class RemindTask
    extends TimerTask {
        RemindTask() {
        }

        public void run() {
            AddNodeDemo.this.process();
        }
    }
}

