/*
 * Decompiled with CFR 0.152.
 */
package samples.graph;

import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.DefaultToolTipFunction;
import edu.uci.ics.jung.graph.decorators.EdgeShape;
import edu.uci.ics.jung.graph.decorators.EllipseVertexShapeFunction;
import edu.uci.ics.jung.graph.decorators.PickableEdgePaintFunction;
import edu.uci.ics.jung.graph.decorators.PickableVertexPaintFunction;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseVertex;
import edu.uci.ics.jung.graph.impl.SparseTree;
import edu.uci.ics.jung.visualization.DefaultGraphLabelRenderer;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.ShapePickSupport;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.contrib.TreeLayout;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.PickingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.PluggableGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ViewScalingControl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TreeLayoutDemo
extends JApplet {
    SparseTree graph;
    VisualizationViewer vv;
    Vertex root = new DirectedSparseVertex();

    public TreeLayoutDemo() {
        this.graph = new SparseTree(this.root);
        Vertex[] vertices = this.createVertices(this.root, 11);
        this.createEdges(vertices);
        PluggableRenderer pr = new PluggableRenderer();
        pr.setVertexPaintFunction(new PickableVertexPaintFunction(pr, Color.black, Color.white, Color.yellow));
        pr.setEdgePaintFunction(new PickableEdgePaintFunction(pr, Color.black, Color.cyan));
        pr.setGraphLabelRenderer(new DefaultGraphLabelRenderer(Color.cyan, Color.cyan));
        pr.setVertexShapeFunction(new EllipseVertexShapeFunction());
        TreeLayout layout = new TreeLayout(this.graph);
        this.vv = new VisualizationViewer(layout, (Renderer)pr, new Dimension(400, 400));
        this.vv.setPickSupport(new ShapePickSupport());
        pr.setEdgeShapeFunction(new EdgeShape.QuadCurve());
        this.vv.setBackground(Color.white);
        this.vv.setToolTipFunction(new DefaultToolTipFunction());
        Container content = this.getContentPane();
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        content.add(panel);
        PluggableGraphMouse graphMouse = new PluggableGraphMouse();
        graphMouse.add(new PickingGraphMousePlugin());
        graphMouse.add(new ScalingGraphMousePlugin(new ViewScalingControl(), 2));
        graphMouse.add(new ScalingGraphMousePlugin(new CrossoverScalingControl(), 0));
        this.vv.setGraphMouse(graphMouse);
        final CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(TreeLayoutDemo.this.vv, 1.1f, TreeLayoutDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(TreeLayoutDemo.this.vv, 0.9090909f, TreeLayoutDemo.this.vv.getCenter());
            }
        });
        JPanel scaleGrid = new JPanel(new GridLayout(1, 0));
        scaleGrid.setBorder(BorderFactory.createTitledBorder("Zoom"));
        JPanel controls = new JPanel();
        scaleGrid.add(plus);
        scaleGrid.add(minus);
        controls.add(scaleGrid);
        content.add((Component)controls, "South");
    }

    private Vertex[] createVertices(Vertex root, int count) {
        Vertex[] v = new Vertex[count];
        v[0] = root;
        for (int i = 1; i < count; ++i) {
            v[i] = this.graph.addVertex(new DirectedSparseVertex());
        }
        return v;
    }

    void createEdges(Vertex[] v) {
        this.graph.addEdge(new DirectedSparseEdge(v[0], v[1]));
        this.graph.addEdge(new DirectedSparseEdge(v[0], v[2]));
        this.graph.addEdge(new DirectedSparseEdge(v[2], v[3]));
        this.graph.addEdge(new DirectedSparseEdge(v[1], v[4]));
        this.graph.addEdge(new DirectedSparseEdge(v[2], v[5]));
        this.graph.addEdge(new DirectedSparseEdge(v[4], v[6]));
        this.graph.addEdge(new DirectedSparseEdge(v[4], v[7]));
        this.graph.addEdge(new DirectedSparseEdge(v[3], v[8]));
        this.graph.addEdge(new DirectedSparseEdge(v[6], v[9]));
        this.graph.addEdge(new DirectedSparseEdge(v[4], v[10]));
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        Container content = frame.getContentPane();
        frame.setDefaultCloseOperation(3);
        content.add(new TreeLayoutDemo());
        frame.pack();
        frame.setVisible(true);
    }
}

