/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.i18n;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.xnap.commons.i18n.I18n;

class I18nCache {
    private final Map i18nByPackage = new HashMap();

    I18nCache() {
    }

    public void clear() {
        this.i18nByPackage.clear();
    }

    public I18n get(String packageName, Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException();
        }
        List list = (List)this.i18nByPackage.get(packageName);
        if (list != null) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                I18n i18n = (I18n)it.next();
                if (!locale.equals(i18n.getLocale())) continue;
                return i18n;
            }
        }
        return null;
    }

    public void put(String packageName, I18n i18n) {
        ArrayList<I18n> list = (ArrayList<I18n>)this.i18nByPackage.get(packageName);
        if (list == null) {
            list = new ArrayList<I18n>();
            this.i18nByPackage.put(packageName, list);
        }
        list.add(i18n);
    }

    public void visit(Visitor visitor) {
        Iterator it = this.i18nByPackage.values().iterator();
        while (it.hasNext()) {
            List list = (List)it.next();
            Iterator it2 = list.iterator();
            while (it2.hasNext()) {
                I18n i18n = (I18n)it2.next();
                visitor.visit(i18n);
            }
        }
    }

    public static interface Visitor {
        public void visit(I18n var1);
    }
}

